package com.viontech.keliu.redis.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.viontech.keliu.redis.contants.RedisConstants.MethodType;

/**
 *  redis 缓存注解
 * @author vion
 *
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RedisCache {
	 
    /**
     * 键
     * @return
     */
    String key() default "";
 
    /**
     * 过期时间
     * @return
     */
    long expired() default -1;
 

    MethodType methodType() default MethodType.GET;
}
