package com.viontech.keliu.log4jdbc;

import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import net.sf.log4jdbc.DataSourceSpyInterceptor;

@Configuration
public class log4jdbcConfiguration {
	
	@Bean
	public BeanNameAutoProxyCreator txProxy() {
		BeanNameAutoProxyCreator creator = new BeanNameAutoProxyCreator();
		creator.setInterceptorNames("log4jdbcInterceptor");
		creator.setBeanNames("dataSource");
		return creator;
	}

	@Bean
	public DataSourceSpyInterceptor log4jdbcInterceptor() {
		return new DataSourceSpyInterceptor();
	}
}
