/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.utils;

import com.viontech.keliu.http.EBodyFormat;
import com.viontech.keliu.http.VionHttpClient;
import com.viontech.keliu.http.VionRequest;
import com.viontech.keliu.http.VionResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HttpUtil {
    private static String address;
    private static String appkey;

    public String getAddress() {
        return address;
    }

    @Value(value="${address:'127.0.0.1:8080'}")
    public void setAddress(String address) {
        if (!address.startsWith("http:/")) {
            address = "http://" + address;
        }
        HttpUtil.address = address;
    }

    public String getAppkey() {
        return appkey;
    }

    @Value(value="${appkey:'appkey'}")
    public void setAppkey(String appkey) {
        HttpUtil.appkey = appkey;
    }

    public HttpUtil() {
        System.out.println();
    }

    public static void send(String URL2, List datas, Consumer<Message> callBack, String atoken) throws IOException {
        Integer msgCode;
        VionRequest request = new VionRequest();
        request.setReadTimeout(300000);
        request.setUri(address + URL2);
        HashMap<String, Object> body = new HashMap<String, Object>();
        JSONObject object = new JSONObject((Object)datas);
        body.put("datas", datas);
        request.setBody(body);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        try {
            int len = request.getBodyStr().getBytes(request.getContentEncoding()).length;
            request.addHeader("Content-Length", Integer.toString(len));
            request.addHeader("Content-Type", "application/json");
            request.addHeader("atoken", atoken);
            request.addHeader("name", "client");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        VionResponse post = VionHttpClient.post(request);
        String msgInfo = "";
        String a = "";
        if (post.getStatus() == 200) {
            JSONObject jo = new JSONObject(post.getBodyStr());
            msgCode = jo.getInt("msg_code");
            msgInfo = jo.getString("msg_info");
            if (atoken.equals("")) {
                a = jo.getString("atoken");
            }
        } else {
            System.out.println("\u51fa\u9519" + post.getStatus());
            msgCode = post.getStatus();
            msgInfo = "\u7f51\u7edc\u51fa\u9519";
        }
        Message message = new Message();
        message.setMsgCode(msgCode);
        message.setMsgInfo(msgInfo);
        message.setAtoken(a);
        callBack.accept(message);
    }

    public static class Message {
        private Integer msgCode;
        private String msgInfo;
        private String atoken;

        public String getAtoken() {
            return this.atoken;
        }

        public void setAtoken(String atoken) {
            this.atoken = atoken;
        }

        public Integer getMsgCode() {
            return this.msgCode;
        }

        public void setMsgCode(Integer msgCode) {
            this.msgCode = msgCode;
        }

        public String getMsgInfo() {
            return this.msgInfo;
        }

        public void setMsgInfo(String msgInfo) {
            this.msgInfo = msgInfo;
        }
    }
}

