/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.http;

import com.viontech.keliu.http.VionRequest;
import com.viontech.keliu.http.VionResponse;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VionHttpClient {
    private List<DeviceLogBean> deviceLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VionResponse post(VionRequest request) throws IOException {
        String charset = request.getContentEncoding();
        String content = request.getBodyStr();
        HashMap<String, String> header = request.getHeaders();
        VionResponse response = new VionResponse();
        FilterOutputStream out = null;
        InputStream is = null;
        try {
            String url = request.getParams().isEmpty() ? request.getUri().toString() : String.format("%s?%s", request.getUri().toString(), request.getParamStr());
            URL console = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)console.openConnection(Proxy.NO_PROXY);
            if (request.getConnectTimeout() != null) {
                conn.setConnectTimeout(request.getConnectTimeout());
            }
            if (request.getReadTimeout() != null) {
                conn.setReadTimeout(request.getReadTimeout());
            }
            for (Map.Entry<String, String> vionResponse : header.entrySet()) {
                conn.setRequestProperty(vionResponse.getKey(), vionResponse.getValue());
            }
            conn.setDoOutput(true);
            conn.connect();
            if (content != null && !content.isEmpty()) {
                out = new DataOutputStream(conn.getOutputStream());
                out.write(content.getBytes(charset));
                ((DataOutputStream)out).flush();
            }
            int statusCode = conn.getResponseCode();
            response.setHeader(conn.getHeaderFields());
            response.setStatus(statusCode);
            response.setCharset(charset);
            if (statusCode != 200) {
                VionResponse vionResponse = response;
                return vionResponse;
            }
            is = conn.getInputStream();
            if (is != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                response.setBody(byteArrayOutputStream.toByteArray());
            }
            VionResponse vionResponse = response;
            return vionResponse;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<DeviceLogBean> getDeviceLog() {
        return this.deviceLog;
    }

    public void setDeviceLog(List<DeviceLogBean> deviceLog) {
        this.deviceLog = deviceLog;
    }

    public static class DeviceLogBean {
        private String mallName;
        private String deviceIP;
        private String deviceSerialNum;
        private String gateName;
        private List<OperateListBean> operateList;

        public String getMallName() {
            return this.mallName;
        }

        public void setMallName(String mallName) {
            this.mallName = mallName;
        }

        public String getDeviceIP() {
            return this.deviceIP;
        }

        public void setDeviceIP(String deviceIP) {
            this.deviceIP = deviceIP;
        }

        public String getDeviceSerialNum() {
            return this.deviceSerialNum;
        }

        public void setDeviceSerialNum(String deviceSerialNum) {
            this.deviceSerialNum = deviceSerialNum;
        }

        public String getGateName() {
            return this.gateName;
        }

        public void setGateName(String gateName) {
            this.gateName = gateName;
        }

        public List<OperateListBean> getOperateList() {
            return this.operateList;
        }

        public void setOperateList(List<OperateListBean> operateList) {
            this.operateList = operateList;
        }

        public static class OperateListBean {
            private String operate;
            private String operateTime;
            private String type;
            private String operateDate;

            public String getOperate() {
                return this.operate;
            }

            public void setOperate(String operate) {
                this.operate = operate;
            }

            public String getOperateTime() {
                return this.operateTime;
            }

            public void setOperateTime(String operateTime) {
                this.operateTime = operateTime;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public String getOperateDate() {
                return this.operateDate;
            }

            public void setOperateDate(String operateDate) {
                this.operateDate = operateDate;
            }
        }
    }
}

