/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service.impl;

import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.base.BaseServiceImpl;
import com.viontech.keliu.mapper.ResourceMapper;
import com.viontech.keliu.model.Group;
import com.viontech.keliu.model.Resource;
import com.viontech.keliu.model.ResourceExample;
import com.viontech.keliu.model.ResourceGroup;
import com.viontech.keliu.service.adapter.GroupService;
import com.viontech.keliu.service.adapter.ResourceGroupService;
import com.viontech.keliu.service.adapter.ResourceService;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceServiceImpl
extends BaseServiceImpl<Resource>
implements ResourceService {
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ResourceGroupService resourceGroupService;

    public BaseMapper<Resource> getMapper() {
        return this.resourceMapper;
    }

    @Override
    @Transactional
    public Group addAndBind2Group(List<Resource> resources) {
        Group group = new Group();
        group.setEndTime(DateUtil.addHours((Date)new Date(), (int)1));
        group.setUnid(UUID.randomUUID().toString().replaceAll("-", ""));
        this.groupService.insertSelective(group);
        resources.forEach(item -> {
            ResourceExample resourceExample = new ResourceExample();
            resourceExample.createColumns().hasIdColumn();
            resourceExample.createCriteria().andUnidEqualTo(item.getUnid());
            List<Resource> resourceList = this.resourceMapper.selectByExample(resourceExample);
            if (resourceList.size() > 0) {
                item.setId(resourceList.get(0).getId());
            } else {
                this.resourceMapper.insertSelective((Resource)((Object)item));
            }
            ResourceGroup resourceGroup = new ResourceGroup();
            resourceGroup.setGroupId(group.getId());
            resourceGroup.setResourceId(item.getId());
            this.resourceGroupService.insertSelective(resourceGroup);
        });
        return group;
    }

    @Override
    @Transactional
    public Group addResourceGroup(List<Resource> resources) {
        Group group = new Group();
        group.setEndTime(DateUtil.addHours((Date)new Date(), (int)1));
        group.setUnid(UUID.randomUUID().toString().replaceAll("-", ""));
        this.groupService.insertSelective(group);
        resources.forEach(item -> {
            ResourceGroup resourceGroup = new ResourceGroup();
            resourceGroup.setGroupId(group.getId());
            resourceGroup.setResourceId(item.getId());
            this.resourceGroupService.insertSelective(resourceGroup);
        });
        return group;
    }
}

