/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.controller.web;

import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.configuration.WxMpConfig;
import com.viontech.keliu.controller.base.TemplateBaseController;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.model.Alarm;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.DataItem;
import com.viontech.keliu.model.Template;
import com.viontech.keliu.model.TemplateExample;
import com.viontech.keliu.model.User;
import com.viontech.keliu.model.UserExample;
import com.viontech.keliu.model.UserResourceMointor;
import com.viontech.keliu.model.UserResourceMointorExample;
import com.viontech.keliu.service.adapter.UserService;
import com.viontech.keliu.service.impl.TemplateServiceImpl;
import com.viontech.keliu.service.impl.UserResourceMointorServiceImpl;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.vo.TemplateVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/templates"})
public class TemplateController
extends TemplateBaseController {
    @Autowired
    private UserService userService;
    @Autowired
    UserResourceMointorServiceImpl userResourceMointorService;
    @Autowired
    TemplateServiceImpl templateService;
    @Autowired
    WxMpConfig wxMpConfig;

    @Override
    protected BaseExample getExample(TemplateVo templateVo, int type) {
        TemplateExample templateExample = (TemplateExample)super.getExample(templateVo, type);
        return templateExample;
    }

    @PostMapping(value={""})
    @ResponseBody
    public Object add(@RequestBody TemplateVo templateVo) {
        templateVo.setUnid(UUID.randomUUID().toString().replaceAll("-", ""));
        Template template = (Template)this.templateService.insertSelective(templateVo);
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), (Object)((Object)template));
    }

    @PostMapping(value={"/{templateId}"})
    @ResponseBody
    public Object updateTemplate(@RequestBody TemplateVo templateVo, @PathVariable(name="templateId") Long templateId) {
        TemplateExample templateExample = new TemplateExample();
        templateExample.createCriteria().andIdEqualTo(templateId);
        List templateList = this.templateService.selectByExample(templateExample);
        if (templateList.size() > 0) {
            Template template = (Template)((Object)templateList.get(0));
            templateVo.setId(template.getId());
            templateVo.setUnid(template.getUnid());
            this.templateService.updateByPrimaryKey(templateVo);
        }
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), (Object)((Object)templateVo));
    }

    @RequestMapping(value={"/{id}/fdsfdsfds/fdsfdsf"}, method={RequestMethod.GET})
    @ResponseBody
    public Object selOne(@PathVariable(value="id") Long id) {
        return null;
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    public Object getTemplateById(@PathVariable(name="id") Long id) {
        TemplateExample templateExample = new TemplateExample();
        templateExample.createCriteria().andIdEqualTo(id);
        List templateList = this.templateService.selectByExample(templateExample);
        Template template = new Template();
        if (templateList.size() > 0) {
            template = (Template)((Object)templateList.get(0));
        }
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), (Object)((Object)template));
    }

    @PostMapping(value={"/send"})
    @ResponseBody
    public Object unbindResource(@RequestBody ArrayList<Alarm> alarms) {
        ArrayList<String> resourceUnids = new ArrayList<String>();
        HashMap<String, ArrayList<Alarm>> alarmMap = new HashMap<String, ArrayList<Alarm>>();
        for (Alarm alarm : alarms) {
            String resourceUnid = alarm.getResourceUnid();
            resourceUnids.add(resourceUnid);
            ArrayList<Alarm> alarmList = (ArrayList<Alarm>)alarmMap.get(resourceUnid);
            if (alarmList == null) {
                alarmList = new ArrayList<Alarm>();
                alarmMap.put(resourceUnid, alarmList);
            }
            alarmList.add(alarm);
        }
        UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
        userResourceMointorExample.createCriteria().andResourceUnidIn(resourceUnids);
        List userResourceMointors = this.userResourceMointorService.selectByExample(userResourceMointorExample);
        Map<String, List<UserResourceMointor>> userResourceMap = userResourceMointors.stream().collect(Collectors.groupingBy(UserResourceMointor::getUserUnid));
        if (userResourceMap.size() <= 0) {
            System.out.println("\u627e\u4e0d\u5230\u7528\u6237\u548c\u8d44\u6e90\u7ed1\u5b9a\u5173\u7cfb");
            return JsonMessageUtil.getSuccessJsonMsg((String)"\u672c\u6b21\u9700\u8981\u62a5\u8b66\u7684\u8d44\u6e90\u6ca1\u6709\u7528\u6237\u5173\u6ce8");
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andUnidIn(new ArrayList<String>(userResourceMap.keySet()));
        List users = this.userService.selectByExample(userExample);
        Map<String, String> userCodeMap = users.stream().collect(Collectors.toMap(User::getUnid, User::getCode));
        userResourceMap.forEach((userUnid, value) -> {
            List<Alarm> alarmList = new ArrayList<Alarm>();
            for (UserResourceMointor userResourceMointor : value) {
                List as = (List)alarmMap.get(userResourceMointor.getResourceUnid());
                if (as == null || as.isEmpty()) continue;
                alarmList.addAll(as);
            }
            alarmList = this.polymerize(alarmList);
            String code = (String)userCodeMap.get(userUnid);
            for (Alarm alarm : alarmList) {
                WxMpService wxMpService = this.wxMpConfig.wxMpService();
                WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder().toUser(code).templateId(alarm.getTemplateId()).build();
                templateMessage.addData(new WxMpTemplateData("first", alarm.getData().getFirst().getValue().toString(), null));
                Data data = alarm.getData();
                if (data.getKeyword1() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword1", data.getKeyword1().getValue().toString(), null));
                }
                if (data.getKeyword2() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword2", data.getKeyword2().getValue().toString(), null));
                }
                if (data.getKeyword3() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword3", data.getKeyword3().getValue().toString(), null));
                }
                if (data.getKeyword4() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword4", data.getKeyword4().getValue().toString(), null));
                }
                if (data.getKeyword5() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword5", data.getKeyword5().getValue().toString(), null));
                }
                if (data.getKeyword6() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword6", data.getKeyword6().getValue().toString(), null));
                }
                if (data.getKeyword7() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword7", data.getKeyword7().getValue().toString(), null));
                }
                if (data.getKeyword8() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword8", data.getKeyword8().getValue().toString(), null));
                }
                if (data.getKeyword9() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword9", data.getKeyword9().getValue().toString(), null));
                }
                if (data.getKeyword10() != null) {
                    templateMessage.addData(new WxMpTemplateData("keyword10", data.getKeyword10().getValue().toString(), null));
                }
                if (data.getRemark() != null) {
                    templateMessage.addData(new WxMpTemplateData("remark", data.getRemark().getValue().toString(), null));
                }
                try {
                    wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                }
                catch (WxErrorException e) {
                    e.printStackTrace();
                }
                System.out.println("\u7ed9\u7528\u6237" + code + "\u53d1\u9001\u6d88\u606f\uff1a" + alarm.toString());
            }
        });
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()));
    }

    @PostMapping(value={"/error/send"})
    @ResponseBody
    public Object unbindResourceTemp(@RequestBody Alarm alarm) {
        WxMpService wxMpService = this.wxMpConfig.wxMpService();
        WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder().toUser("o69nr1UOP2mNXQCZdqPKBfESHvTs").templateId(alarm.getTemplateId()).build();
        templateMessage.addData(new WxMpTemplateData("first", alarm.getData().getFirst().getValue().toString(), null));
        Data data = alarm.getData();
        if (data.getKeyword1() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword1", data.getKeyword1().getValue().toString(), null));
        }
        if (data.getKeyword2() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword2", data.getKeyword2().getValue().toString(), null));
        }
        if (data.getKeyword3() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword3", data.getKeyword3().getValue().toString(), null));
        }
        if (data.getKeyword4() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword4", data.getKeyword4().getValue().toString(), null));
        }
        if (data.getKeyword5() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword5", data.getKeyword5().getValue().toString(), null));
        }
        if (data.getKeyword6() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword6", data.getKeyword6().getValue().toString(), null));
        }
        if (data.getKeyword7() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword7", data.getKeyword7().getValue().toString(), null));
        }
        if (data.getKeyword8() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword8", data.getKeyword8().getValue().toString(), null));
        }
        if (data.getKeyword9() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword9", data.getKeyword9().getValue().toString(), null));
        }
        if (data.getKeyword10() != null) {
            templateMessage.addData(new WxMpTemplateData("keyword10", data.getKeyword10().getValue().toString(), null));
        }
        if (data.getRemark() != null) {
            templateMessage.addData(new WxMpTemplateData("remark", data.getRemark().getValue().toString(), null));
        }
        try {
            wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
        }
        catch (WxErrorException e) {
            e.printStackTrace();
        }
        System.out.println("\u7ed9\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f\uff1a" + alarm.toString());
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()));
    }

    private List<Alarm> polymerize(List<Alarm> alarms) {
        ArrayList<Alarm> result = new ArrayList<Alarm>();
        for (Alarm currentAlarm : alarms) {
            Alarm resultAlarm = this.findEqualsAlarm(result, currentAlarm);
            if (resultAlarm == null) {
                result.add(currentAlarm);
                continue;
            }
            resultAlarm.getData().getRemark().setValue(resultAlarm.getData().getRemark().getValue() + "," + currentAlarm.getData().getRemark().getValue());
        }
        return result;
    }

    private Alarm findEqualsAlarm(List<Alarm> result, Alarm alarm) {
        for (Alarm alarm1 : result) {
            if (!this.alarmEquals(alarm, alarm1)) continue;
            return alarm1;
        }
        return null;
    }

    private boolean alarmEquals(Alarm alarm1, Alarm alarm2) {
        Data data1 = alarm1.getData();
        Data data2 = alarm2.getData();
        if (!this.keyWordEquals(data1.getFirst(), data2.getFirst())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword1(), data2.getKeyword1())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword2(), data2.getKeyword2())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword3(), data2.getKeyword3())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword4(), data2.getKeyword4())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword5(), data2.getKeyword5())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword6(), data2.getKeyword6())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword7(), data2.getKeyword7())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword8(), data2.getKeyword8())) {
            return false;
        }
        if (!this.keyWordEquals(data1.getKeyword9(), data2.getKeyword9())) {
            return false;
        }
        return this.keyWordEquals(data1.getKeyword10(), data2.getKeyword10());
    }

    private boolean keyWordEquals(DataItem keyword1, DataItem keyword2) {
        if (keyword1 == null && keyword2 == null) {
            return true;
        }
        if (keyword1 == null || keyword2 == null) {
            return false;
        }
        if (keyword1.getValue() == null && keyword2.getValue() == null) {
            return true;
        }
        if (keyword1.getValue() == null || keyword2.getValue() == null) {
            return false;
        }
        return keyword1.getValue().equals(keyword2.getValue());
    }
}

