/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.controller.web;

import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.VoInterface;
import com.viontech.keliu.controller.base.ResourceBaseController;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.model.Group;
import com.viontech.keliu.model.Resource;
import com.viontech.keliu.model.ResourceExample;
import com.viontech.keliu.model.ResourceGroupExample;
import com.viontech.keliu.model.User;
import com.viontech.keliu.model.UserExample;
import com.viontech.keliu.model.UserResourceMointor;
import com.viontech.keliu.model.UserResourceMointorExample;
import com.viontech.keliu.service.adapter.ResourceGroupService;
import com.viontech.keliu.service.impl.ResourceServiceImpl;
import com.viontech.keliu.service.impl.UserResourceMointorServiceImpl;
import com.viontech.keliu.service.impl.UserServiceImpl;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.vo.ResourceVo;
import com.viontech.keliu.vo.UserResourceMointorVo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/resources"})
public class ResourceController
extends ResourceBaseController {
    @Value(value="${web.address:}")
    private String weburl;
    private final String BIND_URL = "{0}/api/v1/resources/bind?groupUnid={1}&type=wechat";
    @Autowired
    ResourceServiceImpl resourceService;
    @Autowired
    UserServiceImpl userService;
    @Autowired
    UserResourceMointorServiceImpl userResourceMointorService;
    @Autowired
    ResourceGroupService resourceGroupService;
    @Autowired
    WxMpService wxMpService;

    @Override
    protected BaseExample getExample(@RequestBody ResourceVo resourceVo, int type) {
        ResourceExample resourceExample = (ResourceExample)super.getExample(resourceVo, type);
        return resourceExample;
    }

    @PostMapping(value={""})
    @ResponseBody
    public Object add(@RequestBody ResourceVo resourceVo) {
        List<Resource> resources = resourceVo.getResources();
        Group group = this.resourceService.addAndBind2Group(resources);
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), (Object)((Object)group));
    }

    @GetMapping(value={"/addback"})
    @ResponseBody
    public Object page(ResourceVo resourceVo, int page, int pageSize, String sortName, String sortOrder) {
        return super.page((VoInterface)resourceVo, page, pageSize, sortName, sortOrder);
    }

    @GetMapping(value={""})
    @ResponseBody
    public Object getResourceList(@RequestParam(required=false) String resourceType, @RequestParam(required=false) String userType, @RequestParam String code) {
        UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
        userResourceMointorExample.createColumns();
        userResourceMointorExample.createResourceColumns().hasIdColumn().hasUnidColumn().hasNameColumn().hasTypeColumn().hasDescriptionColumn();
        userResourceMointorExample.andUserCriteria().andCodeEqualTo(code);
        List userResourceMointorList = this.userResourceMointorService.selectByExample(userResourceMointorExample);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (UserResourceMointor userResourceMointor : userResourceMointorList) {
            result.add(userResourceMointor.getResource());
        }
        return JsonMessageUtil.getSuccessJsonMsg(result);
    }

    @PostMapping(value={"/group"})
    @ResponseBody
    public Object addResourceGroup(@RequestBody ResourceVo resourceVo) {
        List<Resource> resources = resourceVo.getResources();
        Group group = this.resourceService.addResourceGroup(resources);
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), (Object)((Object)group));
    }

    @PostMapping(value={"/bindUrl/wechat"})
    @ResponseBody
    public Object bindUrlOfWechat(@RequestBody ResourceVo resourceVo) {
        List<Resource> resources = resourceVo.getResources();
        Group group = this.resourceService.addAndBind2Group(resources);
        String bindUrl = MessageFormat.format("{0}/api/v1/resources/bind?groupUnid={1}&type=wechat", this.weburl, group.getUnid());
        String result = this.wxMpService.oauth2buildAuthorizationUrl(bindUrl, "snsapi_userinfo", null);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("bindUrl", result);
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), resultMap);
    }

    @GetMapping(value={"/type"})
    @ResponseBody
    public Object getResourceType(@RequestParam(required=false) String type, @RequestParam String code) {
        UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
        userResourceMointorExample.createColumns();
        userResourceMointorExample.setDistinct(true);
        userResourceMointorExample.createResourceColumns().hasTypeColumn();
        userResourceMointorExample.andUserCriteria().andCodeEqualTo(code);
        List userResourceMointorList = this.userResourceMointorService.selectByExample(userResourceMointorExample);
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (UserResourceMointor userResourceMointor : userResourceMointorList) {
            result.add(userResourceMointor.getResource());
        }
        return JsonMessageUtil.getSuccessJsonMsg(result);
    }

    @GetMapping(value={"/bind"})
    @ResponseBody
    public ModelAndView bindResource(@RequestParam(required=false) String resourceUnid, @RequestParam(required=false) String groupUnid, @RequestParam String type, @RequestParam String code) {
        ModelAndView mav = new ModelAndView("bind/result");
        if ("wechat".equals(type)) {
            try {
                String openId;
                WxMpOAuth2AccessToken wxMpOAuth2AccessToken = this.wxMpService.oauth2getAccessToken(code);
                code = openId = wxMpOAuth2AccessToken.getOpenId();
                System.out.println(wxMpOAuth2AccessToken);
                WxMpUser wxMpUser = this.wxMpService.getUserService().userInfo(openId);
                System.out.println(wxMpUser.toString());
                if (wxMpUser == null || wxMpUser.getSubscribe() == null || !wxMpUser.getSubscribe().booleanValue()) {
                    mav.addObject("code", (Object)500);
                    mav.addObject("result", (Object)"\u8be5\u7528\u6237\u6ca1\u6709\u5173\u6ce8\u6b64\u516c\u4f17\u53f7");
                    return mav;
                }
            }
            catch (WxErrorException e) {
                e.printStackTrace();
                this.logger.info("code\u8f6c\u6362openid\u51fa\u9519");
                mav.addObject("code", (Object)500);
                mav.addObject("result", (Object)"\u7ed1\u5b9a\u5931\u8d25");
                return mav;
            }
        }
        UserExample userExample = new UserExample();
        UserExample.Criteria criteria = userExample.createCriteria();
        criteria.andCodeEqualTo(code);
        List users = this.userService.selectByExample(userExample);
        User user = null;
        if (users.size() <= 0) {
            user = new User();
            user.setUnid(UUID.randomUUID().toString().replaceAll("-", ""));
            user.setCode(code);
            user.setType(type);
            user.setIsActive(true);
            user = (User)this.userService.insertSelective(user);
        } else {
            user = (User)((Object)users.get(0));
        }
        ArrayList resources = new ArrayList();
        if (groupUnid != null) {
            ResourceGroupExample resourceGroupExample = new ResourceGroupExample();
            resourceGroupExample.createColumns();
            resourceGroupExample.createResourceColumns().hasUnidColumn().hasIdColumn();
            resourceGroupExample.andGroupCriteria().andUnidEqualTo(groupUnid);
            List resourceGroups = this.resourceGroupService.selectByExample(resourceGroupExample);
            resourceGroups.forEach(item -> {
                if (item == null || item.getResource() == null) {
                    return;
                }
                resources.add(item.getResource());
            });
        } else if (resourceUnid != null) {
            ResourceExample resourceExample = new ResourceExample();
            resourceExample.createCriteria().andUnidEqualTo(resourceUnid);
            List resourceList = this.resourceService.selectByExample(resourceExample);
            if (!resourceList.isEmpty()) {
                resources.add(resourceList.get(0));
            }
        }
        for (Resource resource : resources) {
            UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
            userResourceMointorExample.createCriteria().andResourceIdEqualTo(resource.getId()).andUserIdEqualTo(user.getId());
            if (this.userResourceMointorService.countByExample(userResourceMointorExample) > 0) continue;
            UserResourceMointorVo userResourceMointorVo = new UserResourceMointorVo();
            userResourceMointorVo.setUserId(user.getId());
            userResourceMointorVo.setUserUnid(user.getUnid());
            userResourceMointorVo.setResourceUnid(resource.getUnid());
            userResourceMointorVo.setResourceId(resource.getId());
            this.userResourceMointorService.insertSelective(userResourceMointorVo);
        }
        mav.addObject("code", (Object)200);
        mav.addObject("result", (Object)"\u7ed1\u5b9a\u6210\u529f");
        return mav;
    }

    @PostMapping(value={"/unbind"})
    @ResponseBody
    public Object unbindResource(@RequestParam(required=false) String resourceUnid, @RequestParam(required=false) String groupUnid, @RequestParam(required=false) String type, @RequestParam(required=false) String code, @RequestParam(required=false) String userUnid, @RequestParam(required=false) String userid) {
        UserExample userExample = new UserExample();
        userExample.createCriteria().andCodeEqualTo(code);
        List users = this.userService.selectByExample(userExample);
        User user = null;
        if (users.size() >= 0) {
            user = (User)((Object)users.get(0));
            UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
            UserResourceMointorExample.Criteria criteria = userResourceMointorExample.createCriteria();
            criteria.andUserUnidEqualTo(user.getUnid()).andResourceUnidEqualTo(resourceUnid);
            List userResourceMointorList = this.userResourceMointorService.selectByExample(userResourceMointorExample);
            if (userResourceMointorList.size() > 0) {
                for (UserResourceMointor item : userResourceMointorList) {
                    this.userResourceMointorService.deleteByPrimaryKey(item.getId());
                }
            }
        }
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()));
    }
}

