/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.controller.web;

import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.controller.base.ClientBaseController;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.model.Client;
import com.viontech.keliu.model.ClientExample;
import com.viontech.keliu.service.impl.ClientServiceImpl;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.vo.ClientVo;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor"})
public class ClientController
extends ClientBaseController {
    @Autowired
    ClientServiceImpl clientService;

    @Override
    protected BaseExample getExample(ClientVo clientVo, int type) {
        ClientExample clientExample = (ClientExample)super.getExample(clientVo, type);
        return clientExample;
    }

    @PostMapping(value={"/register"})
    @ResponseBody
    public Object add(@RequestBody ClientVo clientVo) {
        clientVo.setUnid(UUID.randomUUID().toString().replaceAll("-", ""));
        clientVo.setRemoteIp(clientVo.getLocalIp());
        Client client = (Client)this.clientService.insertSelective(clientVo);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("clientUnid", client.getUnid());
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), resultMap);
    }

    @PostMapping(value={"/heartbeat"})
    @ResponseBody
    public Object updateClient(@RequestBody ClientVo clientVo) {
        String clienUnid = clientVo.getUnid();
        ClientExample clientExample = new ClientExample();
        clientExample.createCriteria().andUnidEqualTo(clienUnid);
        List clientList = this.clientService.selectByExample(clientExample);
        if (clientList.size() > 0) {
            Client client = (Client)((Object)clientList.get(0));
            client.setHeartbeatTime(clientVo.getHeartbeatTime());
            this.clientService.updateByPrimaryKey(client);
        }
        return JsonMessageUtil.getSuccessJsonMsg((String)LocalMessageUtil.getMessage((String)"addSuccess", ((Object)((Object)this)).getClass()), ((Object)((Object)this)).getClass());
    }
}

