package com.viontech.keliu.model;

import com.viontech.keliu.base.BaseExample;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResourceGroupExample extends BaseExample {

    public ResourceGroupExample() {
        super();
        tableName = "r_resource_group";
        tableAlias = "resourceGroup";
    }

    public ResourceExample.ColumnContainer createResourceColumns() {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.ColumnContainer columnContainer = (ResourceExample.ColumnContainer) columnContainerMap.get(resourceExample.getTableName());
         if(columnContainer == null){
            columnContainer = resourceExample.createColumns();
            columnContainerMap.put(resourceExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public ResourceExample.Criteria andResourceCriteria() {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.Criteria criteria = resourceExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public ResourceExample.Criteria orResourceCriteria() {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.Criteria criteria = resourceExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public ResourceExample.Criteria andResourceCriteria(Criteria criteria) {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.Criteria newCriteria = resourceExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public GroupExample.ColumnContainer createGroupColumns() {
        GroupExample groupExample = new GroupExample();
        GroupExample.ColumnContainer columnContainer = (GroupExample.ColumnContainer) columnContainerMap.get(groupExample.getTableName());
         if(columnContainer == null){
            columnContainer = groupExample.createColumns();
            columnContainerMap.put(groupExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public GroupExample.Criteria andGroupCriteria() {
        GroupExample groupExample = new GroupExample();
        GroupExample.Criteria criteria = groupExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public GroupExample.Criteria orGroupCriteria() {
        GroupExample groupExample = new GroupExample();
        GroupExample.Criteria criteria = groupExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public GroupExample.Criteria andGroupCriteria(Criteria criteria) {
        GroupExample groupExample = new GroupExample();
        GroupExample.Criteria newCriteria = groupExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "r_resource_group";
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("\"resourceGroup\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"resourceGroup\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"resourceGroup\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"resourceGroup\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"resourceGroup\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"resourceGroup\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"resourceGroup\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"resourceGroup\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"resourceGroup\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"resourceGroup\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"resourceGroup\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"resourceGroup\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andResourceIdIsNull() {
            addCriterion("\"resourceGroup\".resource_id is null");
            return (Criteria) this;
        }

        public Criteria andResourceIdIsNotNull() {
            addCriterion("\"resourceGroup\".resource_id is not null");
            return (Criteria) this;
        }

        public Criteria andResourceIdEqualTo(Long value) {
            addCriterion("\"resourceGroup\".resource_id =", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdNotEqualTo(Long value) {
            addCriterion("\"resourceGroup\".resource_id <>", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdGreaterThan(Long value) {
            addCriterion("\"resourceGroup\".resource_id >", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"resourceGroup\".resource_id >=", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdLessThan(Long value) {
            addCriterion("\"resourceGroup\".resource_id <", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdLessThanOrEqualTo(Long value) {
            addCriterion("\"resourceGroup\".resource_id <=", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdIn(List<Long> values) {
            addCriterion("\"resourceGroup\".resource_id in", values, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdNotIn(List<Long> values) {
            addCriterion("\"resourceGroup\".resource_id not in", values, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdBetween(Long value1, Long value2) {
            addCriterion("\"resourceGroup\".resource_id between", value1, value2, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdNotBetween(Long value1, Long value2) {
            addCriterion("\"resourceGroup\".resource_id not between", value1, value2, "resourceId");
            return (Criteria) this;
        }

        public Criteria andGroupIdIsNull() {
            addCriterion("\"resourceGroup\".group_id is null");
            return (Criteria) this;
        }

        public Criteria andGroupIdIsNotNull() {
            addCriterion("\"resourceGroup\".group_id is not null");
            return (Criteria) this;
        }

        public Criteria andGroupIdEqualTo(Long value) {
            addCriterion("\"resourceGroup\".group_id =", value, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdNotEqualTo(Long value) {
            addCriterion("\"resourceGroup\".group_id <>", value, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdGreaterThan(Long value) {
            addCriterion("\"resourceGroup\".group_id >", value, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"resourceGroup\".group_id >=", value, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdLessThan(Long value) {
            addCriterion("\"resourceGroup\".group_id <", value, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdLessThanOrEqualTo(Long value) {
            addCriterion("\"resourceGroup\".group_id <=", value, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdIn(List<Long> values) {
            addCriterion("\"resourceGroup\".group_id in", values, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdNotIn(List<Long> values) {
            addCriterion("\"resourceGroup\".group_id not in", values, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdBetween(Long value1, Long value2) {
            addCriterion("\"resourceGroup\".group_id between", value1, value2, "groupId");
            return (Criteria) this;
        }

        public Criteria andGroupIdNotBetween(Long value1, Long value2) {
            addCriterion("\"resourceGroup\".group_id not between", value1, value2, "groupId");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"resourceGroup\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"resourceGroup\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"resourceGroup\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"resourceGroup\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"resourceGroup\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"resourceGroup\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"resourceGroup\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"resourceGroup\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"resourceGroup\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"resourceGroup\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"resourceGroup\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"resourceGroup\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"resourceGroup\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"resourceGroup\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"resourceGroup\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"resourceGroup\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"resourceGroup\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"resourceGroup\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"resourceGroup\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"resourceGroup\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"resourceGroup\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"resourceGroup\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"resourceGroup\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"resourceGroup\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"resourceGroup\".id as resourceGroup_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasResourceIdColumn() {
            addColumnStr("\"resourceGroup\".resource_id as resourceGroup_resource_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasGroupIdColumn() {
            addColumnStr("\"resourceGroup\".group_id as resourceGroup_group_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"resourceGroup\".modify_time as resourceGroup_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"resourceGroup\".create_time as resourceGroup_create_time ");
            return (ColumnContainer) this;
        }
    }
}