package com.viontech.keliu.model;

import com.viontech.keliu.base.BaseExample;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MessageSendLogExample extends BaseExample {

    public MessageSendLogExample() {
        super();
        tableName = "d_message_send_log";
        tableAlias = "messageSendLog";
    }

    public UserExample.ColumnContainer createUserColumns() {
        UserExample userExample = new UserExample();
        UserExample.ColumnContainer columnContainer = (UserExample.ColumnContainer) columnContainerMap.get(userExample.getTableName());
         if(columnContainer == null){
            columnContainer = userExample.createColumns();
            columnContainerMap.put(userExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public UserExample.Criteria andUserCriteria() {
        UserExample userExample = new UserExample();
        UserExample.Criteria criteria = userExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public UserExample.Criteria orUserCriteria() {
        UserExample userExample = new UserExample();
        UserExample.Criteria criteria = userExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public UserExample.Criteria andUserCriteria(Criteria criteria) {
        UserExample userExample = new UserExample();
        UserExample.Criteria newCriteria = userExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public ResourceExample.ColumnContainer createResourceColumns() {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.ColumnContainer columnContainer = (ResourceExample.ColumnContainer) columnContainerMap.get(resourceExample.getTableName());
         if(columnContainer == null){
            columnContainer = resourceExample.createColumns();
            columnContainerMap.put(resourceExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public ResourceExample.Criteria andResourceCriteria() {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.Criteria criteria = resourceExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public ResourceExample.Criteria orResourceCriteria() {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.Criteria criteria = resourceExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public ResourceExample.Criteria andResourceCriteria(Criteria criteria) {
        ResourceExample resourceExample = new ResourceExample();
        ResourceExample.Criteria newCriteria = resourceExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_message_send_log";
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"messageSendLog\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"messageSendLog\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"messageSendLog\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"messageSendLog\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"messageSendLog\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"messageSendLog\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"messageSendLog\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"messageSendLog\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"messageSendLog\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"messageSendLog\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"messageSendLog\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"messageSendLog\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andUnidIsNull() {
            addCriterion("\"messageSendLog\".unid is null");
            return (Criteria) this;
        }

        public Criteria andUnidIsNotNull() {
            addCriterion("\"messageSendLog\".unid is not null");
            return (Criteria) this;
        }

        public Criteria andUnidEqualTo(String value) {
            addCriterion("\"messageSendLog\".unid =", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidNotEqualTo(String value) {
            addCriterion("\"messageSendLog\".unid <>", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidGreaterThan(String value) {
            addCriterion("\"messageSendLog\".unid >", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidGreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".unid >=", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidLessThan(String value) {
            addCriterion("\"messageSendLog\".unid <", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidLessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".unid <=", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidLike(String value) {
            addCriterion("\"messageSendLog\".unid like", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidNotLike(String value) {
            addCriterion("\"messageSendLog\".unid not like", value, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidIn(List<String> values) {
            addCriterion("\"messageSendLog\".unid in", values, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidNotIn(List<String> values) {
            addCriterion("\"messageSendLog\".unid not in", values, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".unid between", value1, value2, "unid");
            return (Criteria) this;
        }

        public Criteria andUnidNotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".unid not between", value1, value2, "unid");
            return (Criteria) this;
        }

        public Criteria andUserIdIsNull() {
            addCriterion("\"messageSendLog\".user_id is null");
            return (Criteria) this;
        }

        public Criteria andUserIdIsNotNull() {
            addCriterion("\"messageSendLog\".user_id is not null");
            return (Criteria) this;
        }

        public Criteria andUserIdEqualTo(Long value) {
            addCriterion("\"messageSendLog\".user_id =", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdNotEqualTo(Long value) {
            addCriterion("\"messageSendLog\".user_id <>", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdGreaterThan(Long value) {
            addCriterion("\"messageSendLog\".user_id >", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"messageSendLog\".user_id >=", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdLessThan(Long value) {
            addCriterion("\"messageSendLog\".user_id <", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdLessThanOrEqualTo(Long value) {
            addCriterion("\"messageSendLog\".user_id <=", value, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdIn(List<Long> values) {
            addCriterion("\"messageSendLog\".user_id in", values, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdNotIn(List<Long> values) {
            addCriterion("\"messageSendLog\".user_id not in", values, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdBetween(Long value1, Long value2) {
            addCriterion("\"messageSendLog\".user_id between", value1, value2, "userId");
            return (Criteria) this;
        }

        public Criteria andUserIdNotBetween(Long value1, Long value2) {
            addCriterion("\"messageSendLog\".user_id not between", value1, value2, "userId");
            return (Criteria) this;
        }

        public Criteria andUserUnidIsNull() {
            addCriterion("\"messageSendLog\".user_unid is null");
            return (Criteria) this;
        }

        public Criteria andUserUnidIsNotNull() {
            addCriterion("\"messageSendLog\".user_unid is not null");
            return (Criteria) this;
        }

        public Criteria andUserUnidEqualTo(String value) {
            addCriterion("\"messageSendLog\".user_unid =", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidNotEqualTo(String value) {
            addCriterion("\"messageSendLog\".user_unid <>", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidGreaterThan(String value) {
            addCriterion("\"messageSendLog\".user_unid >", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidGreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".user_unid >=", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidLessThan(String value) {
            addCriterion("\"messageSendLog\".user_unid <", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidLessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".user_unid <=", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidLike(String value) {
            addCriterion("\"messageSendLog\".user_unid like", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidNotLike(String value) {
            addCriterion("\"messageSendLog\".user_unid not like", value, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidIn(List<String> values) {
            addCriterion("\"messageSendLog\".user_unid in", values, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidNotIn(List<String> values) {
            addCriterion("\"messageSendLog\".user_unid not in", values, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".user_unid between", value1, value2, "userUnid");
            return (Criteria) this;
        }

        public Criteria andUserUnidNotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".user_unid not between", value1, value2, "userUnid");
            return (Criteria) this;
        }

        public Criteria andResourceIdIsNull() {
            addCriterion("\"messageSendLog\".resource_id is null");
            return (Criteria) this;
        }

        public Criteria andResourceIdIsNotNull() {
            addCriterion("\"messageSendLog\".resource_id is not null");
            return (Criteria) this;
        }

        public Criteria andResourceIdEqualTo(Long value) {
            addCriterion("\"messageSendLog\".resource_id =", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdNotEqualTo(Long value) {
            addCriterion("\"messageSendLog\".resource_id <>", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdGreaterThan(Long value) {
            addCriterion("\"messageSendLog\".resource_id >", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"messageSendLog\".resource_id >=", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdLessThan(Long value) {
            addCriterion("\"messageSendLog\".resource_id <", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdLessThanOrEqualTo(Long value) {
            addCriterion("\"messageSendLog\".resource_id <=", value, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdIn(List<Long> values) {
            addCriterion("\"messageSendLog\".resource_id in", values, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdNotIn(List<Long> values) {
            addCriterion("\"messageSendLog\".resource_id not in", values, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdBetween(Long value1, Long value2) {
            addCriterion("\"messageSendLog\".resource_id between", value1, value2, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceIdNotBetween(Long value1, Long value2) {
            addCriterion("\"messageSendLog\".resource_id not between", value1, value2, "resourceId");
            return (Criteria) this;
        }

        public Criteria andResourceUnidIsNull() {
            addCriterion("\"messageSendLog\".resource_unid is null");
            return (Criteria) this;
        }

        public Criteria andResourceUnidIsNotNull() {
            addCriterion("\"messageSendLog\".resource_unid is not null");
            return (Criteria) this;
        }

        public Criteria andResourceUnidEqualTo(String value) {
            addCriterion("\"messageSendLog\".resource_unid =", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidNotEqualTo(String value) {
            addCriterion("\"messageSendLog\".resource_unid <>", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidGreaterThan(String value) {
            addCriterion("\"messageSendLog\".resource_unid >", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidGreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".resource_unid >=", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidLessThan(String value) {
            addCriterion("\"messageSendLog\".resource_unid <", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidLessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".resource_unid <=", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidLike(String value) {
            addCriterion("\"messageSendLog\".resource_unid like", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidNotLike(String value) {
            addCriterion("\"messageSendLog\".resource_unid not like", value, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidIn(List<String> values) {
            addCriterion("\"messageSendLog\".resource_unid in", values, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidNotIn(List<String> values) {
            addCriterion("\"messageSendLog\".resource_unid not in", values, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".resource_unid between", value1, value2, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andResourceUnidNotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".resource_unid not between", value1, value2, "resourceUnid");
            return (Criteria) this;
        }

        public Criteria andSendTimeIsNull() {
            addCriterion("\"messageSendLog\".send_time is null");
            return (Criteria) this;
        }

        public Criteria andSendTimeIsNotNull() {
            addCriterion("\"messageSendLog\".send_time is not null");
            return (Criteria) this;
        }

        public Criteria andSendTimeEqualTo(Date value) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time =", value, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time <>", value, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeGreaterThan(Date value) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time >", value, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time >=", value, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeLessThan(Date value) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time <", value, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time <=", value, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeIn(List<Date> values) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time in", values, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time not in", values, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time between", value1, value2, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendTimeNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"messageSendLog\".send_time not between", value1, value2, "sendTime");
            return (Criteria) this;
        }

        public Criteria andSendDateIsNull() {
            addCriterion("\"messageSendLog\".send_date is null");
            return (Criteria) this;
        }

        public Criteria andSendDateIsNotNull() {
            addCriterion("\"messageSendLog\".send_date is not null");
            return (Criteria) this;
        }

        public Criteria andSendDateEqualTo(Date value) {
            addCriterion("\"messageSendLog\".send_date =", value, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateNotEqualTo(Date value) {
            addCriterion("\"messageSendLog\".send_date <>", value, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateGreaterThan(Date value) {
            addCriterion("\"messageSendLog\".send_date >", value, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateGreaterThanOrEqualTo(Date value) {
            addCriterion("\"messageSendLog\".send_date >=", value, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateLessThan(Date value) {
            addCriterion("\"messageSendLog\".send_date <", value, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateLessThanOrEqualTo(Date value) {
            addCriterion("\"messageSendLog\".send_date <=", value, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateIn(List<Date> values) {
            addCriterion("\"messageSendLog\".send_date in", values, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateNotIn(List<Date> values) {
            addCriterion("\"messageSendLog\".send_date not in", values, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateBetween(Date value1, Date value2) {
            addCriterion("\"messageSendLog\".send_date between", value1, value2, "sendDate");
            return (Criteria) this;
        }

        public Criteria andSendDateNotBetween(Date value1, Date value2) {
            addCriterion("\"messageSendLog\".send_date not between", value1, value2, "sendDate");
            return (Criteria) this;
        }

        public Criteria andTryCountIsNull() {
            addCriterion("\"messageSendLog\".try_count is null");
            return (Criteria) this;
        }

        public Criteria andTryCountIsNotNull() {
            addCriterion("\"messageSendLog\".try_count is not null");
            return (Criteria) this;
        }

        public Criteria andTryCountEqualTo(Integer value) {
            addCriterion("\"messageSendLog\".try_count =", value, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountNotEqualTo(Integer value) {
            addCriterion("\"messageSendLog\".try_count <>", value, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountGreaterThan(Integer value) {
            addCriterion("\"messageSendLog\".try_count >", value, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"messageSendLog\".try_count >=", value, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountLessThan(Integer value) {
            addCriterion("\"messageSendLog\".try_count <", value, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountLessThanOrEqualTo(Integer value) {
            addCriterion("\"messageSendLog\".try_count <=", value, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountIn(List<Integer> values) {
            addCriterion("\"messageSendLog\".try_count in", values, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountNotIn(List<Integer> values) {
            addCriterion("\"messageSendLog\".try_count not in", values, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountBetween(Integer value1, Integer value2) {
            addCriterion("\"messageSendLog\".try_count between", value1, value2, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTryCountNotBetween(Integer value1, Integer value2) {
            addCriterion("\"messageSendLog\".try_count not between", value1, value2, "tryCount");
            return (Criteria) this;
        }

        public Criteria andTypeIsNull() {
            addCriterion("\"messageSendLog\".\"type\" is null");
            return (Criteria) this;
        }

        public Criteria andTypeIsNotNull() {
            addCriterion("\"messageSendLog\".\"type\" is not null");
            return (Criteria) this;
        }

        public Criteria andTypeEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"type\" =", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"type\" <>", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThan(String value) {
            addCriterion("\"messageSendLog\".\"type\" >", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"type\" >=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThan(String value) {
            addCriterion("\"messageSendLog\".\"type\" <", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"type\" <=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLike(String value) {
            addCriterion("\"messageSendLog\".\"type\" like", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotLike(String value) {
            addCriterion("\"messageSendLog\".\"type\" not like", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeIn(List<String> values) {
            addCriterion("\"messageSendLog\".\"type\" in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotIn(List<String> values) {
            addCriterion("\"messageSendLog\".\"type\" not in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".\"type\" between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".\"type\" not between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andTemplateIdIsNull() {
            addCriterion("\"messageSendLog\".template_id is null");
            return (Criteria) this;
        }

        public Criteria andTemplateIdIsNotNull() {
            addCriterion("\"messageSendLog\".template_id is not null");
            return (Criteria) this;
        }

        public Criteria andTemplateIdEqualTo(String value) {
            addCriterion("\"messageSendLog\".template_id =", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdNotEqualTo(String value) {
            addCriterion("\"messageSendLog\".template_id <>", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdGreaterThan(String value) {
            addCriterion("\"messageSendLog\".template_id >", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdGreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".template_id >=", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdLessThan(String value) {
            addCriterion("\"messageSendLog\".template_id <", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdLessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".template_id <=", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdLike(String value) {
            addCriterion("\"messageSendLog\".template_id like", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdNotLike(String value) {
            addCriterion("\"messageSendLog\".template_id not like", value, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdIn(List<String> values) {
            addCriterion("\"messageSendLog\".template_id in", values, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdNotIn(List<String> values) {
            addCriterion("\"messageSendLog\".template_id not in", values, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".template_id between", value1, value2, "templateId");
            return (Criteria) this;
        }

        public Criteria andTemplateIdNotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".template_id not between", value1, value2, "templateId");
            return (Criteria) this;
        }

        public Criteria andFirstIsNull() {
            addCriterion("\"messageSendLog\".\"first\" is null");
            return (Criteria) this;
        }

        public Criteria andFirstIsNotNull() {
            addCriterion("\"messageSendLog\".\"first\" is not null");
            return (Criteria) this;
        }

        public Criteria andFirstEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"first\" =", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstNotEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"first\" <>", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstGreaterThan(String value) {
            addCriterion("\"messageSendLog\".\"first\" >", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstGreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"first\" >=", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstLessThan(String value) {
            addCriterion("\"messageSendLog\".\"first\" <", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstLessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".\"first\" <=", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstLike(String value) {
            addCriterion("\"messageSendLog\".\"first\" like", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstNotLike(String value) {
            addCriterion("\"messageSendLog\".\"first\" not like", value, "first");
            return (Criteria) this;
        }

        public Criteria andFirstIn(List<String> values) {
            addCriterion("\"messageSendLog\".\"first\" in", values, "first");
            return (Criteria) this;
        }

        public Criteria andFirstNotIn(List<String> values) {
            addCriterion("\"messageSendLog\".\"first\" not in", values, "first");
            return (Criteria) this;
        }

        public Criteria andFirstBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".\"first\" between", value1, value2, "first");
            return (Criteria) this;
        }

        public Criteria andFirstNotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".\"first\" not between", value1, value2, "first");
            return (Criteria) this;
        }

        public Criteria andKeyword1IsNull() {
            addCriterion("\"messageSendLog\".keyword1 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword1IsNotNull() {
            addCriterion("\"messageSendLog\".keyword1 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword1EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword1 =", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword1 <>", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword1 >", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword1 >=", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword1 <", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword1 <=", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1Like(String value) {
            addCriterion("\"messageSendLog\".keyword1 like", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword1 not like", value, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword1 in", values, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword1 not in", values, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword1 between", value1, value2, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword1NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword1 not between", value1, value2, "keyword1");
            return (Criteria) this;
        }

        public Criteria andKeyword2IsNull() {
            addCriterion("\"messageSendLog\".keyword2 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword2IsNotNull() {
            addCriterion("\"messageSendLog\".keyword2 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword2EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword2 =", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword2 <>", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword2 >", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword2 >=", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword2 <", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword2 <=", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2Like(String value) {
            addCriterion("\"messageSendLog\".keyword2 like", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword2 not like", value, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword2 in", values, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword2 not in", values, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword2 between", value1, value2, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword2NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword2 not between", value1, value2, "keyword2");
            return (Criteria) this;
        }

        public Criteria andKeyword3IsNull() {
            addCriterion("\"messageSendLog\".keyword3 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword3IsNotNull() {
            addCriterion("\"messageSendLog\".keyword3 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword3EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword3 =", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword3 <>", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword3 >", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword3 >=", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword3 <", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword3 <=", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3Like(String value) {
            addCriterion("\"messageSendLog\".keyword3 like", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword3 not like", value, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword3 in", values, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword3 not in", values, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword3 between", value1, value2, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword3NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword3 not between", value1, value2, "keyword3");
            return (Criteria) this;
        }

        public Criteria andKeyword4IsNull() {
            addCriterion("\"messageSendLog\".keyword4 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword4IsNotNull() {
            addCriterion("\"messageSendLog\".keyword4 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword4EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword4 =", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword4 <>", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword4 >", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword4 >=", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword4 <", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword4 <=", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4Like(String value) {
            addCriterion("\"messageSendLog\".keyword4 like", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword4 not like", value, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword4 in", values, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword4 not in", values, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword4 between", value1, value2, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword4NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword4 not between", value1, value2, "keyword4");
            return (Criteria) this;
        }

        public Criteria andKeyword5IsNull() {
            addCriterion("\"messageSendLog\".keyword5 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword5IsNotNull() {
            addCriterion("\"messageSendLog\".keyword5 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword5EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword5 =", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword5 <>", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword5 >", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword5 >=", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword5 <", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword5 <=", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5Like(String value) {
            addCriterion("\"messageSendLog\".keyword5 like", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword5 not like", value, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword5 in", values, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword5 not in", values, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword5 between", value1, value2, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword5NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword5 not between", value1, value2, "keyword5");
            return (Criteria) this;
        }

        public Criteria andKeyword6IsNull() {
            addCriterion("\"messageSendLog\".keyword6 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword6IsNotNull() {
            addCriterion("\"messageSendLog\".keyword6 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword6EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword6 =", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword6 <>", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword6 >", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword6 >=", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword6 <", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword6 <=", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6Like(String value) {
            addCriterion("\"messageSendLog\".keyword6 like", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword6 not like", value, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword6 in", values, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword6 not in", values, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword6 between", value1, value2, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword6NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword6 not between", value1, value2, "keyword6");
            return (Criteria) this;
        }

        public Criteria andKeyword7IsNull() {
            addCriterion("\"messageSendLog\".keyword7 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword7IsNotNull() {
            addCriterion("\"messageSendLog\".keyword7 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword7EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword7 =", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword7 <>", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword7 >", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword7 >=", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword7 <", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword7 <=", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7Like(String value) {
            addCriterion("\"messageSendLog\".keyword7 like", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword7 not like", value, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword7 in", values, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword7 not in", values, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword7 between", value1, value2, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword7NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword7 not between", value1, value2, "keyword7");
            return (Criteria) this;
        }

        public Criteria andKeyword8IsNull() {
            addCriterion("\"messageSendLog\".keyword8 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword8IsNotNull() {
            addCriterion("\"messageSendLog\".keyword8 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword8EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword8 =", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword8 <>", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword8 >", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword8 >=", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword8 <", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword8 <=", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8Like(String value) {
            addCriterion("\"messageSendLog\".keyword8 like", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword8 not like", value, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword8 in", values, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword8 not in", values, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword8 between", value1, value2, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword8NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword8 not between", value1, value2, "keyword8");
            return (Criteria) this;
        }

        public Criteria andKeyword9IsNull() {
            addCriterion("\"messageSendLog\".keyword9 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword9IsNotNull() {
            addCriterion("\"messageSendLog\".keyword9 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword9EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword9 =", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword9 <>", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword9 >", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword9 >=", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword9 <", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword9 <=", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9Like(String value) {
            addCriterion("\"messageSendLog\".keyword9 like", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword9 not like", value, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword9 in", values, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword9 not in", values, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword9 between", value1, value2, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword9NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword9 not between", value1, value2, "keyword9");
            return (Criteria) this;
        }

        public Criteria andKeyword10IsNull() {
            addCriterion("\"messageSendLog\".keyword10 is null");
            return (Criteria) this;
        }

        public Criteria andKeyword10IsNotNull() {
            addCriterion("\"messageSendLog\".keyword10 is not null");
            return (Criteria) this;
        }

        public Criteria andKeyword10EqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword10 =", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10NotEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword10 <>", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10GreaterThan(String value) {
            addCriterion("\"messageSendLog\".keyword10 >", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10GreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword10 >=", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10LessThan(String value) {
            addCriterion("\"messageSendLog\".keyword10 <", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10LessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".keyword10 <=", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10Like(String value) {
            addCriterion("\"messageSendLog\".keyword10 like", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10NotLike(String value) {
            addCriterion("\"messageSendLog\".keyword10 not like", value, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10In(List<String> values) {
            addCriterion("\"messageSendLog\".keyword10 in", values, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10NotIn(List<String> values) {
            addCriterion("\"messageSendLog\".keyword10 not in", values, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10Between(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword10 between", value1, value2, "keyword10");
            return (Criteria) this;
        }

        public Criteria andKeyword10NotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".keyword10 not between", value1, value2, "keyword10");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNull() {
            addCriterion("\"messageSendLog\".remark is null");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNotNull() {
            addCriterion("\"messageSendLog\".remark is not null");
            return (Criteria) this;
        }

        public Criteria andRemarkEqualTo(String value) {
            addCriterion("\"messageSendLog\".remark =", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotEqualTo(String value) {
            addCriterion("\"messageSendLog\".remark <>", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThan(String value) {
            addCriterion("\"messageSendLog\".remark >", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".remark >=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThan(String value) {
            addCriterion("\"messageSendLog\".remark <", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThanOrEqualTo(String value) {
            addCriterion("\"messageSendLog\".remark <=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLike(String value) {
            addCriterion("\"messageSendLog\".remark like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotLike(String value) {
            addCriterion("\"messageSendLog\".remark not like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkIn(List<String> values) {
            addCriterion("\"messageSendLog\".remark in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotIn(List<String> values) {
            addCriterion("\"messageSendLog\".remark not in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".remark between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotBetween(String value1, String value2) {
            addCriterion("\"messageSendLog\".remark not between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"messageSendLog\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"messageSendLog\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"messageSendLog\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"messageSendLog\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"messageSendLog\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"messageSendLog\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"messageSendLog\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"messageSendLog\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"messageSendLog\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"messageSendLog\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"messageSendLog\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"messageSendLog\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"messageSendLog\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"messageSendLog\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"messageSendLog\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"messageSendLog\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"messageSendLog\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"messageSendLog\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"messageSendLog\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"messageSendLog\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"messageSendLog\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"messageSendLog\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"messageSendLog\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"messageSendLog\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andStatusIsNull() {
            addCriterion("\"messageSendLog\".\"status\" is null");
            return (Criteria) this;
        }

        public Criteria andStatusIsNotNull() {
            addCriterion("\"messageSendLog\".\"status\" is not null");
            return (Criteria) this;
        }

        public Criteria andStatusEqualTo(Boolean value) {
            addCriterion("\"messageSendLog\".\"status\" =", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotEqualTo(Boolean value) {
            addCriterion("\"messageSendLog\".\"status\" <>", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThan(Boolean value) {
            addCriterion("\"messageSendLog\".\"status\" >", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThanOrEqualTo(Boolean value) {
            addCriterion("\"messageSendLog\".\"status\" >=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThan(Boolean value) {
            addCriterion("\"messageSendLog\".\"status\" <", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThanOrEqualTo(Boolean value) {
            addCriterion("\"messageSendLog\".\"status\" <=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusIn(List<Boolean> values) {
            addCriterion("\"messageSendLog\".\"status\" in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotIn(List<Boolean> values) {
            addCriterion("\"messageSendLog\".\"status\" not in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusBetween(Boolean value1, Boolean value2) {
            addCriterion("\"messageSendLog\".\"status\" between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotBetween(Boolean value1, Boolean value2) {
            addCriterion("\"messageSendLog\".\"status\" not between", value1, value2, "status");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"messageSendLog\".id as messageSendLog_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasUnidColumn() {
            addColumnStr("\"messageSendLog\".unid as messageSendLog_unid ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasUserIdColumn() {
            addColumnStr("\"messageSendLog\".user_id as messageSendLog_user_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasUserUnidColumn() {
            addColumnStr("\"messageSendLog\".user_unid as messageSendLog_user_unid ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasResourceIdColumn() {
            addColumnStr("\"messageSendLog\".resource_id as messageSendLog_resource_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasResourceUnidColumn() {
            addColumnStr("\"messageSendLog\".resource_unid as messageSendLog_resource_unid ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasSendTimeColumn() {
            addColumnStr("\"messageSendLog\".send_time as messageSendLog_send_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasSendDateColumn() {
            addColumnStr("\"messageSendLog\".send_date as messageSendLog_send_date ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTryCountColumn() {
            addColumnStr("\"messageSendLog\".try_count as messageSendLog_try_count ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTypeColumn() {
            addColumnStr("\"messageSendLog\".\"type\" as \"messageSendLog_type\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTemplateIdColumn() {
            addColumnStr("\"messageSendLog\".template_id as messageSendLog_template_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFirstColumn() {
            addColumnStr("\"messageSendLog\".\"first\" as \"messageSendLog_first\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword1Column() {
            addColumnStr("\"messageSendLog\".keyword1 as messageSendLog_keyword1 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword2Column() {
            addColumnStr("\"messageSendLog\".keyword2 as messageSendLog_keyword2 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword3Column() {
            addColumnStr("\"messageSendLog\".keyword3 as messageSendLog_keyword3 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword4Column() {
            addColumnStr("\"messageSendLog\".keyword4 as messageSendLog_keyword4 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword5Column() {
            addColumnStr("\"messageSendLog\".keyword5 as messageSendLog_keyword5 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword6Column() {
            addColumnStr("\"messageSendLog\".keyword6 as messageSendLog_keyword6 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword7Column() {
            addColumnStr("\"messageSendLog\".keyword7 as messageSendLog_keyword7 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword8Column() {
            addColumnStr("\"messageSendLog\".keyword8 as messageSendLog_keyword8 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword9Column() {
            addColumnStr("\"messageSendLog\".keyword9 as messageSendLog_keyword9 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasKeyword10Column() {
            addColumnStr("\"messageSendLog\".keyword10 as messageSendLog_keyword10 ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasRemarkColumn() {
            addColumnStr("\"messageSendLog\".remark as messageSendLog_remark ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"messageSendLog\".modify_time as messageSendLog_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"messageSendLog\".create_time as messageSendLog_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasStatusColumn() {
            addColumnStr("\"messageSendLog\".\"status\" as \"messageSendLog_status\" ");
            return (ColumnContainer) this;
        }
    }
}