package com.viontech.keliu.controller.web;

import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.controller.base.UserBaseController;
import com.viontech.keliu.model.User;
import com.viontech.keliu.model.UserExample;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.vo.UserVo;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/users")
public class UserController extends UserBaseController {

    @Autowired
    WxMpService wxMpService;

    @Override
    protected BaseExample getExample(UserVo userVo, int type) {
        UserExample userExample = (UserExample) super.getExample(userVo, type);
        return userExample;
    }

    @GetMapping("/openId")
    @ResponseBody
    public Object getResourceList(@RequestParam String code) {

        try {

            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
            String openId = wxMpOAuth2AccessToken.getOpenId();
            code = openId;
            //判断用户是否关注  如果不关注 返回提示信息
            System.out.println(wxMpOAuth2AccessToken);

            WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
            System.out.println(wxMpUser.toString());
            if (wxMpUser == null || wxMpUser.getSubscribe() == null || !wxMpUser.getSubscribe()) {
                return JsonMessageUtil.getErrorJsonMsg("该用户没有关注此公众号");
            }
        } catch (WxErrorException e) {
            e.printStackTrace();
            // 返回错误信息
            logger.info("code转换openid出错");
            throw new IllegalStateException("无法获取用户openId");
        }

        return  JsonMessageUtil.getSuccessJsonMsg(code);
    }
}
