package com.viontech.keliu.controller.web;


import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.controller.base.ResourceBaseController;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.model.*;
import com.viontech.keliu.service.adapter.ResourceGroupService;
import com.viontech.keliu.service.impl.ResourceServiceImpl;
import com.viontech.keliu.service.impl.UserResourceMointorServiceImpl;
import com.viontech.keliu.service.impl.UserServiceImpl;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.vo.ResourceVo;
import com.viontech.keliu.vo.UserResourceMointorVo;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import java.text.MessageFormat;
import java.util.*;


@Controller
@RequestMapping("/resources")
public class ResourceController extends ResourceBaseController {

    @Value("${web.address:}")
    private String weburl;


    private final String BIND_URL = "{0}/api/v1/resources/bind?groupUnid={1}&type=wechat";
    @Autowired
    ResourceServiceImpl resourceService;
    @Autowired
    UserServiceImpl userService;
    @Autowired
    UserResourceMointorServiceImpl userResourceMointorService;
    @Autowired
    ResourceGroupService resourceGroupService;
    @Autowired
    WxMpService wxMpService;


    @Override
    protected BaseExample getExample(@RequestBody ResourceVo resourceVo, int type) {
        ResourceExample resourceExample = (ResourceExample) super.getExample(resourceVo, type);
        return resourceExample;
    }

    @Override
    @PostMapping("")
    @ResponseBody
    public Object add(@RequestBody ResourceVo resourceVo) {
        List<Resource> resources = resourceVo.getResources();
        Group group = resourceService.addAndBind2Group(resources);
        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), group);
    }


    @Override
    @GetMapping("/addback")
    @ResponseBody
    public Object page(ResourceVo resourceVo, int page, int pageSize, String sortName, String sortOrder) {
        return super.page(resourceVo, page, pageSize, sortName, sortOrder);
    }


    @GetMapping("")
    @ResponseBody
    public Object getResourceList(@RequestParam(required = false) String resourceType,
                                 @RequestParam(required = false) String userType,
                                 @RequestParam String code) {
        //        if("wechat".equals(userType)){//微信需要将code转换为openid
        //            try {
        //
        //                WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
        //                String openId = wxMpOAuth2AccessToken.getOpenId();
        //                code = openId;
        //                //判断用户是否关注  如果不关注 返回提示信息
        //                System.out.println(wxMpOAuth2AccessToken);
        //
        //                WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
        //                System.out.println(wxMpUser.toString());
        //                if(wxMpUser == null || wxMpUser.getSubscribe() == null || !wxMpUser.getSubscribe()){
        //                    return JsonMessageUtil.getErrorJsonMsg("该用户没有关注此公众号");
        //                }
        //            } catch (WxErrorException e) {
        //                e.printStackTrace();
        //                // 返回错误信息
        //                logger.info("code转换openid出错");
        //                throw new IllegalStateException("无法获取用户openId");
        //            }
        //        }

        UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
        userResourceMointorExample.createColumns();
        userResourceMointorExample.createResourceColumns().hasIdColumn().hasUnidColumn().hasNameColumn().hasTypeColumn().hasDescriptionColumn();
        userResourceMointorExample.andUserCriteria().andCodeEqualTo(code);
        List<UserResourceMointor> userResourceMointorList = userResourceMointorService.selectByExample(userResourceMointorExample);
        List<Resource> result = new ArrayList<>();
        for (UserResourceMointor userResourceMointor : userResourceMointorList) {
            result.add(userResourceMointor.getResource());
        }

        return JsonMessageUtil.getSuccessJsonMsg(result);
    }


    @PostMapping("/group")
    @ResponseBody
    public Object addResourceGroup(@RequestBody ResourceVo resourceVo) {
        List<Resource> resources = resourceVo.getResources();
        Group group = resourceService.addResourceGroup(resources);
        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), group);
    }

    @PostMapping("/bindUrl/wechat")
    @ResponseBody
    public Object bindUrlOfWechat(@RequestBody ResourceVo resourceVo) {
        List<Resource> resources = resourceVo.getResources();
        Group group = resourceService.addAndBind2Group(resources);
        String bindUrl = MessageFormat.format(BIND_URL, weburl, group.getUnid());

        String result = wxMpService.oauth2buildAuthorizationUrl(bindUrl, WxConsts.OAuth2Scope.SNSAPI_USERINFO, null);
        Map resultMap = new HashMap<>();
        resultMap.put("bindUrl", result);

        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), resultMap);
    }

    @GetMapping("/type")
    @ResponseBody
    public Object getResourceType(@RequestParam(required = false) String type,
                                 @RequestParam String code) {
        //        if("wechat".equals(type)){//微信需要将code转换为openid
        //            try {
        //
        //                WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
        //                String openId = wxMpOAuth2AccessToken.getOpenId();
        //                code = openId;
        //                //判断用户是否关注  如果不关注 返回提示信息
        //                System.out.println(wxMpOAuth2AccessToken);
        //
        //                WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
        //                System.out.println(wxMpUser.toString());
        //                if(wxMpUser == null || wxMpUser.getSubscribe() == null || !wxMpUser.getSubscribe()){
        //                    return JsonMessageUtil.getErrorJsonMsg("该用户没有关注此公众号");
        //                }
        //            } catch (WxErrorException e) {
        //                e.printStackTrace();
        //                // 返回错误信息
        //                logger.info("code转换openid出错");
        //                throw new IllegalStateException("无法获取用户openId");
        //            }
        //        }

        UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
        userResourceMointorExample.createColumns();
        userResourceMointorExample.setDistinct(true);
        userResourceMointorExample.createResourceColumns().hasTypeColumn();
        userResourceMointorExample.andUserCriteria().andCodeEqualTo(code);
        List<UserResourceMointor> userResourceMointorList = userResourceMointorService.selectByExample(userResourceMointorExample);
        List<Resource> result = new ArrayList<>();
        for (UserResourceMointor userResourceMointor : userResourceMointorList) {
            result.add(userResourceMointor.getResource());
        }

        return JsonMessageUtil.getSuccessJsonMsg(result);
    }

    @GetMapping("/bind")
    @ResponseBody
    public ModelAndView bindResource(@RequestParam(required = false) String resourceUnid,
                                    @RequestParam(required = false) String groupUnid,
                                    @RequestParam String type,
                                    @RequestParam String code) {

        ModelAndView mav = new ModelAndView("bind/result");
        if ("wechat".equals(type)) {//微信需要将code转换为openid
            try {

                WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
                String openId = wxMpOAuth2AccessToken.getOpenId();
                code = openId;
                //判断用户是否关注  如果不关注 返回提示信息
                System.out.println(wxMpOAuth2AccessToken);

                WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
                System.out.println(wxMpUser.toString());
                if (wxMpUser == null || wxMpUser.getSubscribe() == null || !wxMpUser.getSubscribe()) {
                    mav.addObject("code", 500);
                    mav.addObject("result", "该用户没有关注此公众号");
                    return mav;
                }
            } catch (WxErrorException e) {
                e.printStackTrace();
                // 返回错误信息
                logger.info("code转换openid出错");
                mav.addObject("code", 500);
                mav.addObject("result", "绑定失败");
                return mav;
            }
        }
        UserExample userExample = new UserExample();
        UserExample.Criteria criteria = userExample.createCriteria();
        criteria.andCodeEqualTo(code);

        List<User> users = userService.selectByExample(userExample);
        User user = null;
        if (users.size() <= 0) {
            //新建用户
            user = new User();
            user.setUnid(UUID.randomUUID().toString().replaceAll("-", ""));
            user.setCode(code);
            user.setType(type);
            user.setIsActive(true);
            user = userService.insertSelective(user);
        } else {
            user = users.get(0);
        }
        List<Resource> resources = new ArrayList<>();
        if (groupUnid != null) {
            ResourceGroupExample resourceGroupExample = new ResourceGroupExample();
            resourceGroupExample.createColumns();
            resourceGroupExample.createResourceColumns().hasUnidColumn().hasIdColumn();
            resourceGroupExample.andGroupCriteria().andUnidEqualTo(groupUnid);
            List<ResourceGroup> resourceGroups = resourceGroupService.selectByExample(resourceGroupExample);

            resourceGroups.forEach(item -> {
                if (item == null || item.getResource() == null) {
                    return;
                }
                resources.add(item.getResource());

            });
        } else if (resourceUnid != null) {
            ResourceExample resourceExample = new ResourceExample();
            resourceExample.createCriteria().andUnidEqualTo(resourceUnid);
            List<Resource> resourceList = resourceService.selectByExample(resourceExample);
            if (!resourceList.isEmpty()) {
                resources.add(resourceList.get(0));
            }
        }

        for (Resource resource : resources) {
            // 插入的时候可能重复 要先判断数据库是否存在 不存在才插入
            UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
            userResourceMointorExample.createCriteria().andResourceIdEqualTo(resource.getId()).andUserIdEqualTo(user.getId());
            if (userResourceMointorService.countByExample(userResourceMointorExample) > 0) {
                continue;
            }
            UserResourceMointorVo userResourceMointorVo = new UserResourceMointorVo();
            userResourceMointorVo.setUserId(user.getId());
            userResourceMointorVo.setUserUnid(user.getUnid());
            userResourceMointorVo.setResourceUnid(resource.getUnid());
            userResourceMointorVo.setResourceId(resource.getId());
            userResourceMointorService.insertSelective(userResourceMointorVo);
        }
        mav.addObject("code", 200);
        mav.addObject("result", "绑定成功");
        return mav;
    }

    @PostMapping("/unbind")
    @ResponseBody
    public Object unbindResource(@RequestParam(required = false) String resourceUnid,
                                @RequestParam(required = false) String groupUnid,
                                @RequestParam(required = false) String type,
                                @RequestParam(required = false) String code,
                                @RequestParam(required = false) String userUnid,
                                @RequestParam(required = false) String userid) {

        //        if("wechat".equals(type)){//微信需要将code转换为openid
        //            try {
        //
        //                WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
        //                String openId = wxMpOAuth2AccessToken.getOpenId();
        //                code = openId;
        //                //判断用户是否关注  如果不关注 返回提示信息
        //                System.out.println(wxMpOAuth2AccessToken);
        //
        //                WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
        //                System.out.println(wxMpUser.toString());
        //                if(wxMpUser == null || wxMpUser.getSubscribe() == null || !wxMpUser.getSubscribe()){
        //                    return JsonMessageUtil.getErrorJsonMsg("该用户没有关注此公众号");
        //                }
        //            } catch (WxErrorException e) {
        //                e.printStackTrace();
        //                // 返回错误信息
        //                logger.info("code转换openid出错");
        //                throw new IllegalStateException("无法获取用户openId");
        //            }
        //        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andCodeEqualTo(code);
        List<User> users = userService.selectByExample(userExample);
        User user = null;
        if (users.size() >= 0) {

            user = users.get(0);
            UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
            UserResourceMointorExample.Criteria criteria = userResourceMointorExample.createCriteria();
            criteria.andUserUnidEqualTo(user.getUnid()).andResourceUnidEqualTo(resourceUnid);
            List<UserResourceMointor> userResourceMointorList = userResourceMointorService.selectByExample(userResourceMointorExample);

            if (userResourceMointorList.size() > 0) {
                for (UserResourceMointor item : userResourceMointorList) {
                    userResourceMointorService.deleteByPrimaryKey(item.getId());
                }
            }
        }


        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()));
    }


}