package com.viontech.keliu.controller.web;

import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.controller.base.ClientBaseController;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.model.Client;
import com.viontech.keliu.model.ClientExample;
import com.viontech.keliu.service.impl.ClientServiceImpl;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.vo.ClientVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Controller
@RequestMapping("/monitor")
public class ClientController extends ClientBaseController {

    @Autowired
    ClientServiceImpl clientService;
    @Override
    protected BaseExample getExample(ClientVo clientVo, int type) {
        ClientExample clientExample = (ClientExample)super.getExample(clientVo,type);
        return clientExample;
    }


    @Override
    @PostMapping("/register")
    @ResponseBody
    public Object add(@RequestBody ClientVo clientVo) {
        clientVo.setUnid(UUID.randomUUID().toString().replaceAll("-",""));
        clientVo.setRemoteIp(clientVo.getLocalIp());
        Client client= clientService.insertSelective(clientVo);

        Map resultMap = new HashMap<>();
        resultMap.put("clientUnid",client.getUnid());

        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), resultMap);
    }

    @PostMapping("/heartbeat")
    @ResponseBody
    public Object updateClient(@RequestBody ClientVo clientVo) {
        String clienUnid=clientVo.getUnid();
        ClientExample clientExample=new ClientExample();

        clientExample.createCriteria().andUnidEqualTo(clienUnid);
        List<Client> clientList=clientService.selectByExample(clientExample);
        if(clientList.size()>0)
        {
            Client client=clientList.get(0);
            client.setHeartbeatTime(clientVo.getHeartbeatTime());

            clientService.updateByPrimaryKey(client);
        }
        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), this.getClass());
    }
}