package com.viontech.keliu.controller.base;

import com.viontech.keliu.base.BaseController;
import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.mapper.MessageSendLogMapper;
import com.viontech.keliu.model.MessageSendLog;
import com.viontech.keliu.model.MessageSendLogExample;
import com.viontech.keliu.service.adapter.MessageSendLogService;
import com.viontech.keliu.vo.MessageSendLogVo;
import javax.annotation.Resource;

public abstract class MessageSendLogBaseController extends BaseController<MessageSendLog, MessageSendLogVo> {
    @Resource
    protected MessageSendLogService messageSendLogService;

    @Override
    protected BaseExample getExample(MessageSendLogVo messageSendLogVo, int type) {
        MessageSendLogExample messageSendLogExample = new MessageSendLogExample();
        MessageSendLogExample.Criteria criteria = messageSendLogExample.createCriteria();
        if(messageSendLogVo.getId() != null) {
            criteria.andIdEqualTo(messageSendLogVo.getId());
        }
        if(messageSendLogVo.getId_arr() != null) {
            criteria.andIdIn(messageSendLogVo.getId_arr());
        }
        if(messageSendLogVo.getId_gt() != null) {
            criteria.andIdGreaterThan(messageSendLogVo.getId_gt());
        }
        if(messageSendLogVo.getId_lt() != null) {
            criteria.andIdLessThan(messageSendLogVo.getId_lt());
        }
        if(messageSendLogVo.getId_gte() != null) {
            criteria.andIdGreaterThanOrEqualTo(messageSendLogVo.getId_gte());
        }
        if(messageSendLogVo.getId_lte() != null) {
            criteria.andIdLessThanOrEqualTo(messageSendLogVo.getId_lte());
        }
        if(messageSendLogVo.getUnid() != null) {
            criteria.andUnidEqualTo(messageSendLogVo.getUnid());
        }
        if(messageSendLogVo.getUnid_like() != null) {
            criteria.andUnidLike(messageSendLogVo.getUnid_like());
        }
        if(messageSendLogVo.getUserId() != null) {
            criteria.andUserIdEqualTo(messageSendLogVo.getUserId());
        }
        if(messageSendLogVo.getUserId_arr() != null) {
            criteria.andUserIdIn(messageSendLogVo.getUserId_arr());
        }
        if(messageSendLogVo.getUserId_gt() != null) {
            criteria.andUserIdGreaterThan(messageSendLogVo.getUserId_gt());
        }
        if(messageSendLogVo.getUserId_lt() != null) {
            criteria.andUserIdLessThan(messageSendLogVo.getUserId_lt());
        }
        if(messageSendLogVo.getUserId_gte() != null) {
            criteria.andUserIdGreaterThanOrEqualTo(messageSendLogVo.getUserId_gte());
        }
        if(messageSendLogVo.getUserId_lte() != null) {
            criteria.andUserIdLessThanOrEqualTo(messageSendLogVo.getUserId_lte());
        }
        if(messageSendLogVo.getUserUnid() != null) {
            criteria.andUserUnidEqualTo(messageSendLogVo.getUserUnid());
        }
        if(messageSendLogVo.getUserUnid_like() != null) {
            criteria.andUserUnidLike(messageSendLogVo.getUserUnid_like());
        }
        if(messageSendLogVo.getResourceId() != null) {
            criteria.andResourceIdEqualTo(messageSendLogVo.getResourceId());
        }
        if(messageSendLogVo.getResourceId_arr() != null) {
            criteria.andResourceIdIn(messageSendLogVo.getResourceId_arr());
        }
        if(messageSendLogVo.getResourceId_gt() != null) {
            criteria.andResourceIdGreaterThan(messageSendLogVo.getResourceId_gt());
        }
        if(messageSendLogVo.getResourceId_lt() != null) {
            criteria.andResourceIdLessThan(messageSendLogVo.getResourceId_lt());
        }
        if(messageSendLogVo.getResourceId_gte() != null) {
            criteria.andResourceIdGreaterThanOrEqualTo(messageSendLogVo.getResourceId_gte());
        }
        if(messageSendLogVo.getResourceId_lte() != null) {
            criteria.andResourceIdLessThanOrEqualTo(messageSendLogVo.getResourceId_lte());
        }
        if(messageSendLogVo.getResourceUnid() != null) {
            criteria.andResourceUnidEqualTo(messageSendLogVo.getResourceUnid());
        }
        if(messageSendLogVo.getResourceUnid_like() != null) {
            criteria.andResourceUnidLike(messageSendLogVo.getResourceUnid_like());
        }
        if(messageSendLogVo.getSendTime() != null) {
            criteria.andSendTimeEqualTo(messageSendLogVo.getSendTime());
        }
        if(messageSendLogVo.getSendTime_gt() != null) {
            criteria.andSendTimeGreaterThan(messageSendLogVo.getSendTime_gt());
        }
        if(messageSendLogVo.getSendTime_lt() != null) {
            criteria.andSendTimeLessThan(messageSendLogVo.getSendTime_lt());
        }
        if(messageSendLogVo.getSendTime_gte() != null) {
            criteria.andSendTimeGreaterThanOrEqualTo(messageSendLogVo.getSendTime_gte());
        }
        if(messageSendLogVo.getSendTime_lte() != null) {
            criteria.andSendTimeLessThanOrEqualTo(messageSendLogVo.getSendTime_lte());
        }
        if(messageSendLogVo.getSendDate() != null) {
            criteria.andSendDateEqualTo(messageSendLogVo.getSendDate());
        }
        if(messageSendLogVo.getSendDate_gt() != null) {
            criteria.andSendDateGreaterThan(messageSendLogVo.getSendDate_gt());
        }
        if(messageSendLogVo.getSendDate_lt() != null) {
            criteria.andSendDateLessThan(messageSendLogVo.getSendDate_lt());
        }
        if(messageSendLogVo.getSendDate_gte() != null) {
            criteria.andSendDateGreaterThanOrEqualTo(messageSendLogVo.getSendDate_gte());
        }
        if(messageSendLogVo.getSendDate_lte() != null) {
            criteria.andSendDateLessThanOrEqualTo(messageSendLogVo.getSendDate_lte());
        }
        if(messageSendLogVo.getTryCount() != null) {
            criteria.andTryCountEqualTo(messageSendLogVo.getTryCount());
        }
        if(messageSendLogVo.getTryCount_gt() != null) {
            criteria.andTryCountGreaterThan(messageSendLogVo.getTryCount_gt());
        }
        if(messageSendLogVo.getTryCount_lt() != null) {
            criteria.andTryCountLessThan(messageSendLogVo.getTryCount_lt());
        }
        if(messageSendLogVo.getTryCount_gte() != null) {
            criteria.andTryCountGreaterThanOrEqualTo(messageSendLogVo.getTryCount_gte());
        }
        if(messageSendLogVo.getTryCount_lte() != null) {
            criteria.andTryCountLessThanOrEqualTo(messageSendLogVo.getTryCount_lte());
        }
        if(messageSendLogVo.getType() != null) {
            criteria.andTypeEqualTo(messageSendLogVo.getType());
        }
        if(messageSendLogVo.getType_like() != null) {
            criteria.andTypeLike(messageSendLogVo.getType_like());
        }
        if(messageSendLogVo.getTemplateId() != null) {
            criteria.andTemplateIdEqualTo(messageSendLogVo.getTemplateId());
        }
        if(messageSendLogVo.getTemplateId_null() != null) {
            if(messageSendLogVo.getTemplateId_null().booleanValue()) {
                criteria.andTemplateIdIsNull();
            } else {
                criteria.andTemplateIdIsNotNull();
            }
        }
        if(messageSendLogVo.getTemplateId_like() != null) {
            criteria.andTemplateIdLike(messageSendLogVo.getTemplateId_like());
        }
        if(messageSendLogVo.getFirst() != null) {
            criteria.andFirstEqualTo(messageSendLogVo.getFirst());
        }
        if(messageSendLogVo.getFirst_null() != null) {
            if(messageSendLogVo.getFirst_null().booleanValue()) {
                criteria.andFirstIsNull();
            } else {
                criteria.andFirstIsNotNull();
            }
        }
        if(messageSendLogVo.getFirst_like() != null) {
            criteria.andFirstLike(messageSendLogVo.getFirst_like());
        }
        if(messageSendLogVo.getKeyword1() != null) {
            criteria.andKeyword1EqualTo(messageSendLogVo.getKeyword1());
        }
        if(messageSendLogVo.getKeyword1_null() != null) {
            if(messageSendLogVo.getKeyword1_null().booleanValue()) {
                criteria.andKeyword1IsNull();
            } else {
                criteria.andKeyword1IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword1_like() != null) {
            criteria.andKeyword1Like(messageSendLogVo.getKeyword1_like());
        }
        if(messageSendLogVo.getKeyword2() != null) {
            criteria.andKeyword2EqualTo(messageSendLogVo.getKeyword2());
        }
        if(messageSendLogVo.getKeyword2_null() != null) {
            if(messageSendLogVo.getKeyword2_null().booleanValue()) {
                criteria.andKeyword2IsNull();
            } else {
                criteria.andKeyword2IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword2_like() != null) {
            criteria.andKeyword2Like(messageSendLogVo.getKeyword2_like());
        }
        if(messageSendLogVo.getKeyword3() != null) {
            criteria.andKeyword3EqualTo(messageSendLogVo.getKeyword3());
        }
        if(messageSendLogVo.getKeyword3_null() != null) {
            if(messageSendLogVo.getKeyword3_null().booleanValue()) {
                criteria.andKeyword3IsNull();
            } else {
                criteria.andKeyword3IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword3_like() != null) {
            criteria.andKeyword3Like(messageSendLogVo.getKeyword3_like());
        }
        if(messageSendLogVo.getKeyword4() != null) {
            criteria.andKeyword4EqualTo(messageSendLogVo.getKeyword4());
        }
        if(messageSendLogVo.getKeyword4_null() != null) {
            if(messageSendLogVo.getKeyword4_null().booleanValue()) {
                criteria.andKeyword4IsNull();
            } else {
                criteria.andKeyword4IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword4_like() != null) {
            criteria.andKeyword4Like(messageSendLogVo.getKeyword4_like());
        }
        if(messageSendLogVo.getKeyword5() != null) {
            criteria.andKeyword5EqualTo(messageSendLogVo.getKeyword5());
        }
        if(messageSendLogVo.getKeyword5_null() != null) {
            if(messageSendLogVo.getKeyword5_null().booleanValue()) {
                criteria.andKeyword5IsNull();
            } else {
                criteria.andKeyword5IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword5_like() != null) {
            criteria.andKeyword5Like(messageSendLogVo.getKeyword5_like());
        }
        if(messageSendLogVo.getKeyword6() != null) {
            criteria.andKeyword6EqualTo(messageSendLogVo.getKeyword6());
        }
        if(messageSendLogVo.getKeyword6_null() != null) {
            if(messageSendLogVo.getKeyword6_null().booleanValue()) {
                criteria.andKeyword6IsNull();
            } else {
                criteria.andKeyword6IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword6_like() != null) {
            criteria.andKeyword6Like(messageSendLogVo.getKeyword6_like());
        }
        if(messageSendLogVo.getKeyword7() != null) {
            criteria.andKeyword7EqualTo(messageSendLogVo.getKeyword7());
        }
        if(messageSendLogVo.getKeyword7_null() != null) {
            if(messageSendLogVo.getKeyword7_null().booleanValue()) {
                criteria.andKeyword7IsNull();
            } else {
                criteria.andKeyword7IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword7_like() != null) {
            criteria.andKeyword7Like(messageSendLogVo.getKeyword7_like());
        }
        if(messageSendLogVo.getKeyword8() != null) {
            criteria.andKeyword8EqualTo(messageSendLogVo.getKeyword8());
        }
        if(messageSendLogVo.getKeyword8_null() != null) {
            if(messageSendLogVo.getKeyword8_null().booleanValue()) {
                criteria.andKeyword8IsNull();
            } else {
                criteria.andKeyword8IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword8_like() != null) {
            criteria.andKeyword8Like(messageSendLogVo.getKeyword8_like());
        }
        if(messageSendLogVo.getKeyword9() != null) {
            criteria.andKeyword9EqualTo(messageSendLogVo.getKeyword9());
        }
        if(messageSendLogVo.getKeyword9_null() != null) {
            if(messageSendLogVo.getKeyword9_null().booleanValue()) {
                criteria.andKeyword9IsNull();
            } else {
                criteria.andKeyword9IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword9_like() != null) {
            criteria.andKeyword9Like(messageSendLogVo.getKeyword9_like());
        }
        if(messageSendLogVo.getKeyword10() != null) {
            criteria.andKeyword10EqualTo(messageSendLogVo.getKeyword10());
        }
        if(messageSendLogVo.getKeyword10_null() != null) {
            if(messageSendLogVo.getKeyword10_null().booleanValue()) {
                criteria.andKeyword10IsNull();
            } else {
                criteria.andKeyword10IsNotNull();
            }
        }
        if(messageSendLogVo.getKeyword10_like() != null) {
            criteria.andKeyword10Like(messageSendLogVo.getKeyword10_like());
        }
        if(messageSendLogVo.getRemark() != null) {
            criteria.andRemarkEqualTo(messageSendLogVo.getRemark());
        }
        if(messageSendLogVo.getRemark_null() != null) {
            if(messageSendLogVo.getRemark_null().booleanValue()) {
                criteria.andRemarkIsNull();
            } else {
                criteria.andRemarkIsNotNull();
            }
        }
        if(messageSendLogVo.getRemark_like() != null) {
            criteria.andRemarkLike(messageSendLogVo.getRemark_like());
        }
        if(messageSendLogVo.getModifyTime() != null) {
            criteria.andModifyTimeEqualTo(messageSendLogVo.getModifyTime());
        }
        if(messageSendLogVo.getModifyTime_gt() != null) {
            criteria.andModifyTimeGreaterThan(messageSendLogVo.getModifyTime_gt());
        }
        if(messageSendLogVo.getModifyTime_lt() != null) {
            criteria.andModifyTimeLessThan(messageSendLogVo.getModifyTime_lt());
        }
        if(messageSendLogVo.getModifyTime_gte() != null) {
            criteria.andModifyTimeGreaterThanOrEqualTo(messageSendLogVo.getModifyTime_gte());
        }
        if(messageSendLogVo.getModifyTime_lte() != null) {
            criteria.andModifyTimeLessThanOrEqualTo(messageSendLogVo.getModifyTime_lte());
        }
        if(messageSendLogVo.getCreateTime() != null) {
            criteria.andCreateTimeEqualTo(messageSendLogVo.getCreateTime());
        }
        if(messageSendLogVo.getCreateTime_gt() != null) {
            criteria.andCreateTimeGreaterThan(messageSendLogVo.getCreateTime_gt());
        }
        if(messageSendLogVo.getCreateTime_lt() != null) {
            criteria.andCreateTimeLessThan(messageSendLogVo.getCreateTime_lt());
        }
        if(messageSendLogVo.getCreateTime_gte() != null) {
            criteria.andCreateTimeGreaterThanOrEqualTo(messageSendLogVo.getCreateTime_gte());
        }
        if(messageSendLogVo.getCreateTime_lte() != null) {
            criteria.andCreateTimeLessThanOrEqualTo(messageSendLogVo.getCreateTime_lte());
        }
        if(messageSendLogVo.getStatus() != null) {
            criteria.andStatusEqualTo(messageSendLogVo.getStatus());
        }
        if(messageSendLogVo.getStatus_gt() != null) {
            criteria.andStatusGreaterThan(messageSendLogVo.getStatus_gt());
        }
        if(messageSendLogVo.getStatus_lt() != null) {
            criteria.andStatusLessThan(messageSendLogVo.getStatus_lt());
        }
        if(messageSendLogVo.getStatus_gte() != null) {
            criteria.andStatusGreaterThanOrEqualTo(messageSendLogVo.getStatus_gte());
        }
        if(messageSendLogVo.getStatus_lte() != null) {
            criteria.andStatusLessThanOrEqualTo(messageSendLogVo.getStatus_lte());
        }
        return messageSendLogExample;
    }

    @Override
    protected BaseService<MessageSendLog> getService() {
        return messageSendLogService;
    }
}