package com.viontech.keliu.controller.base;

import com.viontech.keliu.base.BaseController;
import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.mapper.ClientMapper;
import com.viontech.keliu.model.Client;
import com.viontech.keliu.model.ClientExample;
import com.viontech.keliu.service.adapter.ClientService;
import com.viontech.keliu.vo.ClientVo;
import javax.annotation.Resource;

public abstract class ClientBaseController extends BaseController<Client, ClientVo> {
    @Resource
    protected ClientService clientService;

    @Override
    protected BaseExample getExample(ClientVo clientVo, int type) {
        ClientExample clientExample = new ClientExample();
        ClientExample.Criteria criteria = clientExample.createCriteria();
        if(clientVo.getId() != null) {
            criteria.andIdEqualTo(clientVo.getId());
        }
        if(clientVo.getId_arr() != null) {
            criteria.andIdIn(clientVo.getId_arr());
        }
        if(clientVo.getId_gt() != null) {
            criteria.andIdGreaterThan(clientVo.getId_gt());
        }
        if(clientVo.getId_lt() != null) {
            criteria.andIdLessThan(clientVo.getId_lt());
        }
        if(clientVo.getId_gte() != null) {
            criteria.andIdGreaterThanOrEqualTo(clientVo.getId_gte());
        }
        if(clientVo.getId_lte() != null) {
            criteria.andIdLessThanOrEqualTo(clientVo.getId_lte());
        }
        if(clientVo.getUnid() != null) {
            criteria.andUnidEqualTo(clientVo.getUnid());
        }
        if(clientVo.getUnid_like() != null) {
            criteria.andUnidLike(clientVo.getUnid_like());
        }
        if(clientVo.getName() != null) {
            criteria.andNameEqualTo(clientVo.getName());
        }
        if(clientVo.getName_like() != null) {
            criteria.andNameLike(clientVo.getName_like());
        }
        if(clientVo.getLocalIp() != null) {
            criteria.andLocalIpEqualTo(clientVo.getLocalIp());
        }
        if(clientVo.getLocalIp_like() != null) {
            criteria.andLocalIpLike(clientVo.getLocalIp_like());
        }
        if(clientVo.getRemoteIp() != null) {
            criteria.andRemoteIpEqualTo(clientVo.getRemoteIp());
        }
        if(clientVo.getRemoteIp_like() != null) {
            criteria.andRemoteIpLike(clientVo.getRemoteIp_like());
        }
        if(clientVo.getHeartbeatTime_gt() != null) {
            criteria.andModifyTimeGreaterThan(clientVo.getHeartbeatTime_gt());
        }
        if(clientVo.getHeartbeatTime_lt() != null) {
            criteria.andModifyTimeLessThan(clientVo.getHeartbeatTime_lt());
        }
        if(clientVo.getHeartbeatTime_gte() != null) {
            criteria.andModifyTimeGreaterThanOrEqualTo(clientVo.getHeartbeatTime_gte());
        }
        if(clientVo.getHeartbeatTime_lte() != null) {
            criteria.andModifyTimeLessThanOrEqualTo(clientVo.getHeartbeatTime_lte());
        }
        if(clientVo.getDescription() != null) {
            criteria.andDescriptionEqualTo(clientVo.getDescription());
        }
        if(clientVo.getDescription_null() != null) {
            if(clientVo.getDescription_null().booleanValue()) {
                criteria.andDescriptionIsNull();
            } else {
                criteria.andDescriptionIsNotNull();
            }
        }
        if(clientVo.getDescription_like() != null) {
            criteria.andDescriptionLike(clientVo.getDescription_like());
        }
        if(clientVo.getModifyTime() != null) {
            criteria.andModifyTimeEqualTo(clientVo.getModifyTime());
        }
        if(clientVo.getModifyTime_gt() != null) {
            criteria.andModifyTimeGreaterThan(clientVo.getModifyTime_gt());
        }
        if(clientVo.getModifyTime_lt() != null) {
            criteria.andModifyTimeLessThan(clientVo.getModifyTime_lt());
        }
        if(clientVo.getModifyTime_gte() != null) {
            criteria.andModifyTimeGreaterThanOrEqualTo(clientVo.getModifyTime_gte());
        }
        if(clientVo.getModifyTime_lte() != null) {
            criteria.andModifyTimeLessThanOrEqualTo(clientVo.getModifyTime_lte());
        }
        if(clientVo.getCreateTime() != null) {
            criteria.andCreateTimeEqualTo(clientVo.getCreateTime());
        }
        if(clientVo.getCreateTime_gt() != null) {
            criteria.andCreateTimeGreaterThan(clientVo.getCreateTime_gt());
        }
        if(clientVo.getCreateTime_lt() != null) {
            criteria.andCreateTimeLessThan(clientVo.getCreateTime_lt());
        }
        if(clientVo.getCreateTime_gte() != null) {
            criteria.andCreateTimeGreaterThanOrEqualTo(clientVo.getCreateTime_gte());
        }
        if(clientVo.getCreateTime_lte() != null) {
            criteria.andCreateTimeLessThanOrEqualTo(clientVo.getCreateTime_lte());
        }
        if(clientVo.getStatus() != null) {
            criteria.andStatusEqualTo(clientVo.getStatus());
        }
        if(clientVo.getStatus_gt() != null) {
            criteria.andStatusGreaterThan(clientVo.getStatus_gt());
        }
        if(clientVo.getStatus_lt() != null) {
            criteria.andStatusLessThan(clientVo.getStatus_lt());
        }
        if(clientVo.getStatus_gte() != null) {
            criteria.andStatusGreaterThanOrEqualTo(clientVo.getStatus_gte());
        }
        if(clientVo.getStatus_lte() != null) {
            criteria.andStatusLessThanOrEqualTo(clientVo.getStatus_lte());
        }
        return clientExample;
    }

    @Override
    protected BaseService<Client> getService() {
        return clientService;
    }
}