package com.viontech.keliu.service;


import com.viontech.keliu.dao.FaceDataDao;
import com.viontech.keliu.model.FaceData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


@Service
public class FaceDataService {

    @Autowired
    private FaceDataDao facedataDao;
    //记录数据的增量时间
    private static Date face_account_day_modifyTime = null;
    private static Date face_account_hour_modifyTime = null;
    private static Date face_gate_day_modifyTime = null;
    private static Date face_gate_hour_modifyTime = null;

    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String modifyTime = dateFormat.format(new Date());
    private Date now = null;

    {
        try {
            now = dateFormat.parse(modifyTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }

    }

    public List<FaceData> getFacePlazaDayData() {

        if (face_account_day_modifyTime == null) {
            face_account_day_modifyTime = now;
        }
        System.out.println("时间：" + face_account_day_modifyTime);
        List<FaceData> tempList = facedataDao.getFacePlazaDayData(face_account_day_modifyTime);
        if (tempList.size() > 0) {
            face_account_day_modifyTime = tempList.get(0).getModify_time();
        }
        System.out.println("时间：" + face_account_day_modifyTime);
        return tempList;
    }

    public List<FaceData> getFacePlazaHourData() {
        if (face_account_hour_modifyTime == null) {
            face_account_hour_modifyTime = now;
        }
        System.out.println("时间：" + face_account_hour_modifyTime);
        List<FaceData> tempList = facedataDao.getFacePlazaHourData(face_account_hour_modifyTime);
        if (tempList.size() > 0) {
            face_account_hour_modifyTime = tempList.get(0).getModify_time();
        }
        System.out.println("时间：" + face_account_hour_modifyTime);
        return tempList;
    }

    public List<FaceData> getFaceGateDayData() {

        if (face_gate_day_modifyTime == null) {
            face_gate_day_modifyTime = now;
        }
        System.out.println("时间：" + face_gate_day_modifyTime);
        List<FaceData> tempList = facedataDao.getFaceGateDayData(face_gate_day_modifyTime);
        if (tempList.size() > 0) {
            face_gate_day_modifyTime = tempList.get(0).getModify_time();
        }
        System.out.println("时间：" + face_gate_day_modifyTime);
        return tempList;
    }

    public List<FaceData> getFaceGateHourData() {

        if (face_gate_hour_modifyTime == null) {
            face_gate_hour_modifyTime = now;
        }
        System.out.println("时间：" + face_gate_hour_modifyTime);
        List<FaceData> tempList = facedataDao.getFaceGateHourData(face_gate_hour_modifyTime);
        if (tempList.size() > 0) {
            face_gate_hour_modifyTime = tempList.get(0).getModify_time();
        }
        System.out.println("时间：" + face_gate_hour_modifyTime);
        return tempList;
    }

}
