package com.viontech.keliu.service;


import com.viontech.keliu.dao.DataDao;
import com.viontech.keliu.model.FlowData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2018-10-23
 * @description
 */
@Service
public class DataService {

    @Autowired
    private DataDao dataDao;
    //记录数据的增量时间
    private static Date account_day_modifyTime = null;
    private static Date account_hour_modifyTime = null;
    private static Date account_minute_modifyTime = null;
    private static Date account_gate_minute_modifyTime = null;
    private static Date floor_day_modifyTime = null;
    private static Date floor_hour_modifyTime = null;
    private static Date shop_day_modifyTime = null;
    private static Date gate_day_modifyTime = null;
    private static Date shop_hour_modifyTime = null;
    private static Date gate_hour_modifyTime = null;

    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String modifyTime = dateFormat.format(new Date());
    private Date now = null;

    {
        try {
            now = dateFormat.parse(modifyTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public List<FlowData> getPlazaDayData() {

        if (account_day_modifyTime == null) {
            account_day_modifyTime = now;
        }
        System.out.println("时间：" + account_day_modifyTime);
        List<FlowData> tempList = dataDao.getPlazaDayData(account_day_modifyTime);
        if (tempList.size() > 0) {
            account_day_modifyTime = tempList.get(0).getModifyTime();
        }
        System.out.println("时间：" + account_day_modifyTime);
        return tempList;
    }

    public List<FlowData> getPlazaHourData() {
        if (account_hour_modifyTime == null) {
            account_hour_modifyTime = now;
        }
        System.out.println("时间：" + account_hour_modifyTime);
        List<FlowData> tempList = dataDao.getPlazaHourData(account_hour_modifyTime);
        if (tempList.size() > 0) {
            account_hour_modifyTime = tempList.get(0).getModifyTime();
        }
        System.out.println("时间：" + account_hour_modifyTime);
        return tempList;
    }

    public List<FlowData> getPlazaMinuteData() {
        if (account_minute_modifyTime == null) {
            account_minute_modifyTime = now;
        }
        System.out.println("时间：" + account_minute_modifyTime);
        List<FlowData> tempList = dataDao.getPlazaMinuteData(account_minute_modifyTime);
        if (tempList.size() > 0) {
            account_minute_modifyTime = tempList.get(0).getModifyTime();
        }
        System.out.println("时间：" + account_minute_modifyTime);
        return tempList;
    }

    public List<FlowData> getGateMinuteData() {

        if (account_gate_minute_modifyTime == null) {
            account_gate_minute_modifyTime = now;
        }
        System.out.println("时间：" + account_gate_minute_modifyTime);
        List<FlowData> tempList = dataDao.getGateMinuteData(account_gate_minute_modifyTime);
        if (tempList.size() > 0) {
            account_gate_minute_modifyTime = tempList.get(0).getModifyTime();
        }
        System.out.println("时间：" + account_gate_minute_modifyTime);
        return tempList;
    }

    public List<FlowData> getFloorDayData() {

        if (floor_day_modifyTime == null) {
            floor_day_modifyTime = now;
        }
        List<FlowData> tempList = dataDao.getFloorDayData(floor_day_modifyTime);
        if (tempList.size() > 0) {
            floor_day_modifyTime = tempList.get(0).getModifyTime();
        }
        return tempList;
    }

    public List<FlowData> getFloorHourData() {

        if (floor_hour_modifyTime == null) {
            floor_hour_modifyTime = now;
        }
        List<FlowData> tempList = dataDao.getFloorHourData(floor_hour_modifyTime);
        if (tempList.size() > 0) {
            floor_hour_modifyTime = tempList.get(0).getModifyTime();
        }
        return tempList;
    }

    public List<FlowData> getZoneDayData() {

        if (shop_day_modifyTime == null) {
            shop_day_modifyTime = now;
        }
        List<FlowData> tempList = dataDao.getZoneDayData(shop_day_modifyTime);
        if (tempList.size() > 0) {
            shop_day_modifyTime = tempList.get(0).getModifyTime();
        }
        return tempList;
    }

    public List<FlowData> getZoneHourData() {

        if (shop_hour_modifyTime == null) {
            shop_hour_modifyTime = now;
        }
        List<FlowData> tempList = dataDao.getZoneHourData(shop_hour_modifyTime);
        if (tempList.size() > 0) {
            shop_hour_modifyTime = tempList.get(0).getModifyTime();
        }
        return tempList;
    }

    public List<FlowData> getGateDayData() {

        if (gate_day_modifyTime == null) {
            gate_day_modifyTime = now;
        }
        List<FlowData> tempList = dataDao.getGateDayData(gate_day_modifyTime);
        if (tempList.size() > 0) {
            gate_day_modifyTime = tempList.get(0).getModifyTime();
        }
        return tempList;
    }

    public List<FlowData> getGateHourData() {

        if (gate_hour_modifyTime == null) {
            gate_hour_modifyTime = now;
        }
        List<FlowData> tempList = dataDao.getGateHourData(gate_hour_modifyTime);
        if (tempList.size() > 0) {
            gate_hour_modifyTime = tempList.get(0).getModifyTime();
        }
        return tempList;
    }
}
