package com.viontech.keliu.job;


import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.dao.SendDataDao;
import com.viontech.keliu.model.FaceData;
import com.viontech.keliu.model.User;
import com.viontech.keliu.utils.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2018-11-16
 * @description 历史数据
 */
@Slf4j
@Component
public class SendDataSyncJob {

    @Autowired
    private SendDataDao sendDataDao;
    @Autowired
    private User user;


    public void sendExactnessData(Date begin, Date end, String unid) throws IOException {

        List<User> list = new ArrayList<User>();
        list.add(user);
        HttpUtil.send(URLConstants.LOGIN_URL, list, (message) -> {
            if (message.getAtoken() != null && !"".equals(message.getAtoken())) {
                Global.atoken = message.getAtoken();
            }
        }, "");
        Global.sleep();


        log.info("=================(历史数据)广场天精准客流开始请求==============");
        List<FaceData> plazaDayList = sendDataDao.getFacePlazaDayData(begin, end, unid);
        update(plazaDayList, URLConstants.FACE_PLAZA_DAY_URL);

        log.info("=================(历史数据)广场天精准客流开始请求==============");
        List<FaceData> plazaHourList = sendDataDao.getFacePlazaHourData(begin, end, unid);
        update(plazaHourList, URLConstants.FACE_PLAZA_HOUR_URL);

        log.info("=================(历史数据)广场天精准客流开始请求==============");
        List<FaceData> gateDayList = sendDataDao.getFaceGateDayData(begin, end, unid);
        update(gateDayList, URLConstants.FACE_GATE_DAY_URL);

        log.info("=================(历史数据)广场天精准客流开始请求==============");
        List<FaceData> gateHourList = sendDataDao.getFaceGateHourData(begin, end, unid);
        update(gateHourList, URLConstants.FACE_GATE_HOUR_URL);

    }

    public void sendCountData(Date begin, Date end, String unid) throws IOException {
        List<User> list = new ArrayList<User>();
        list.add(user);
        HttpUtil.send(URLConstants.LOGIN_URL, list, (message) -> {
            if (message.getAtoken() != null && !"".equals(message.getAtoken())) {
                Global.atoken = message.getAtoken();
            }
        }, "");
        Global.sleep();

        log.info("=================(历史数据)广场天数据开始请求==============");
        update(sendDataDao.getPlazaDayData(begin, end, unid), URLConstants.PLAZE_DAY_URL);
        log.info("=================(历史数据)广场小时数据开始请求==============");
        update(sendDataDao.getPlazaHourData(begin, end, unid), URLConstants.PLAZE_HOUR_URL);
        log.info("=================(历史数据)广场十分钟数据流开始请求==============");
        update(sendDataDao.getPlazaMinuteData(begin, end, unid), URLConstants.PLAZE_TEN_MINUTE_URL);

        log.info("=================(历史数据)楼层天数据开始请求==============");
        update(sendDataDao.getFloorDayData(begin, end, unid), URLConstants.FLOOR_DAY_URL);
        log.info("=================(历史数据)楼层小时数据开始请求==============");
        update(sendDataDao.getFloorHourData(begin, end, unid), URLConstants.FLOOR_HOUR_URL);

        log.info("=================(历史数据)区域天数据开始请求==============");
        update(sendDataDao.getZoneDayData(begin, end, unid), URLConstants.ZONE_DAY_URL);
        log.info("=================(历史数据)区域小时开始请求==============");
        update(sendDataDao.getZoneHourData(begin, end, unid), URLConstants.ZONE_HOUR_URL);

        log.info("=================(历史数据)出入口天数据开始请求==============");
        update(sendDataDao.getGateDayData(begin, end, unid), URLConstants.GATE_DAY_URL);
        log.info("=================(历史数据)出入口小时数据开始请求==============");
        update(sendDataDao.getGateHourData(begin, end, unid), URLConstants.GATE_HOUR_URL);
        log.info("=================(历史数据)出入口十分钟数据开始请求==============");
        update(sendDataDao.getGateMinuteData(begin, end, unid), URLConstants.PLAZE_GATE_TEN_MINUTE_URL);
    }


    private void update(List list, String url) throws IOException {
        log.info("FaceList.size={}", list.size());
        HttpUtil.send(url, list, (message) -> {
            message.getMsgInfo();
            message.getMsgCode();
            log.info(message.getMsgInfo());
        }, Global.atoken);

        Global.sleep();
    }
}
