package com.viontech.keliu.job;


import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.dao.AccountDao;
import com.viontech.keliu.model.*;
import com.viontech.keliu.utils.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2018-10-23
 * @description
 */
@Slf4j
@Component
public class OrgSyncJob {

    @Autowired
    private AccountDao accountDao;
    @Autowired
    private User user;

    public void execute() throws IOException {
        List<User> list = new ArrayList<User>();
        list.add(user);
        HttpUtil.send(URLConstants.LOGIN_URL, list, (message) -> {
            if (message.getAtoken() != null && !"".equals(message.getAtoken())) {
                Global.atoken = message.getAtoken();
            }
        }, "");
        Global.sleep();

        log.info("=================广场组织关系开始请求==============");
        List<Plaza> plazaList = accountDao.getPlaza();
        update(plazaList, URLConstants.PLAZA_URL);

        log.info("=================楼层组织关系开始请求==============");
        List<Floor> floorList = accountDao.getFloor();
        update(floorList, URLConstants.FLOOR_URL);

        log.info("=================店铺组织关系开始请求==============");
        List<Zone> zoneList = accountDao.getZone();
        update(zoneList, URLConstants.ZONE_URL);

        log.info("=================出入口组织关系开始请求==============");
        List<Gate> gateList = accountDao.getGate();
        update(gateList, URLConstants.GATE_URL);

        log.info("=================楼层出入口组织关系开始请求==============");
        List<Relation> floorGateList = accountDao.getFloorGate();
        floorGateList.forEach(r -> r.setDirection(r.getDirection() - 1));
        update(floorGateList, URLConstants.FLOOR_GATE_RELATION_URL);

        log.info("=================店铺出入口组织关系开始请求==============");
        List<Relation> zoneGateList = accountDao.getZoneGate();
        zoneGateList.forEach(r -> r.setDirection(r.getDirection() - 1));
        update(zoneGateList, URLConstants.ZONE_GATE_RELATION_URL);
    }


    private void update(List list, String url) throws IOException {
        log.info("floorList.size={}", list.size());
        HttpUtil.send(url, list, (message) -> {
            message.getMsgInfo();
            message.getMsgCode();
            log.info(message.getMsgInfo());
        }, Global.atoken);
        Global.sleep();
    }

}
