package com.viontech.keliu.job;


import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.model.FaceData;
import com.viontech.keliu.model.User;
import com.viontech.keliu.service.FaceDataService;
import com.viontech.keliu.utils.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2018-10-23
 * @description
 */
@Slf4j
@Component
public class FaceDataSyncJob {

    @Autowired
    private FaceDataService facaDataService;
    @Autowired
    private User user;

    public void execute() throws IOException {
        List<User> list = new ArrayList<User>();
        list.add(user);
        HttpUtil.send(URLConstants.LOGIN_URL, list, (message) -> {
            if (message.getAtoken() != null && !"".equals(message.getAtoken())) {
                Global.atoken = message.getAtoken();
            }
        }, "");
        Global.sleep();

        log.info("=================广场天精准客流开始请求==============");
        List<FaceData> plazaDayList = facaDataService.getFacePlazaDayData();
        update(plazaDayList, URLConstants.FACE_PLAZA_DAY_URL);

        log.info("=================广场小时精准客流开始请求==============");
        List<FaceData> plazaHourList = facaDataService.getFacePlazaHourData();
        update(plazaHourList, URLConstants.FACE_PLAZA_HOUR_URL);

        log.info("=================出入口天精准客流开始请求==============");
        List<FaceData> gateDayList = facaDataService.getFaceGateDayData();
        update(gateDayList, URLConstants.FACE_GATE_DAY_URL);

        log.info("=================出入口小时精准客流开始请求==============");
        List<FaceData> gateHourList = facaDataService.getFaceGateHourData();
        update(gateHourList, URLConstants.FACE_GATE_HOUR_URL);

    }


    private void update(List list, String url) throws IOException {
        log.info("FaceList.size={}", list.size());
        HttpUtil.send(url, list, (message) -> {
            message.getMsgInfo();
            message.getMsgCode();
            log.info(message.getMsgInfo());
        }, Global.atoken);

        Global.sleep();
    }

}
