package com.viontech.keliu.job;


import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.model.FlowData;
import com.viontech.keliu.model.User;
import com.viontech.keliu.service.DataService;
import com.viontech.keliu.utils.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2018-10-23
 * @description
 */
@Slf4j
@Component
public class DataSyncJob {

    @Autowired
    private DataService dataService;
    @Autowired
    private User user;

    public void execute() throws IOException {

        List<User> list = new ArrayList<>();
        list.add(user);
        HttpUtil.send(URLConstants.LOGIN_URL, list, (message) -> {
            if (message.getAtoken() != null && !"".equals(message.getAtoken())) {
                Global.atoken = message.getAtoken();
            }
        }, "");
        Global.sleep();

        log.info("=================广场天数据系开始请求==============");
        update(dataService.getPlazaDayData(), URLConstants.PLAZE_DAY_URL);

        log.info("=================广场小时数据系开始请求==============");
        update(dataService.getPlazaHourData(), URLConstants.PLAZE_HOUR_URL);

        log.info("=================广场十分钟数据系开始请求==============");
        update(dataService.getPlazaMinuteData(), URLConstants.PLAZE_TEN_MINUTE_URL);

        log.info("=================广场级出入口十分钟数据系开始请求==============");
        update(dataService.getGateMinuteData(), URLConstants.PLAZE_GATE_TEN_MINUTE_URL);

        log.info("=================楼层天数据系开始请求==============");
        update(dataService.getFloorDayData(), URLConstants.FLOOR_DAY_URL);

        log.info("=================楼层小时数据系开始请求==============");
        update(dataService.getFloorHourData(), URLConstants.FLOOR_HOUR_URL);

        log.info("=================店铺天数据系开始请求==============");
        update(dataService.getZoneDayData(), URLConstants.ZONE_DAY_URL);

        log.info("=================店铺小时数据系开始请求==============");
        update(dataService.getZoneHourData(), URLConstants.ZONE_HOUR_URL);

        log.info("=================出入口天数据系开始请求==============");
        update(dataService.getGateDayData(), URLConstants.GATE_DAY_URL);

        log.info("=================出入口小时数据系开始请求==============");
        update(dataService.getGateHourData(), URLConstants.GATE_HOUR_URL);
    }


    private void update(List<FlowData> list, String url) throws IOException {
        log.info("floorList.size={}", list.size());
        HttpUtil.send(url, list, (message) -> {
            message.getMsgInfo();
            message.getMsgCode();
            log.info(message.getMsgInfo());
        }, Global.atoken);
        Global.sleep();
    }
}
