package com.viontech.keliu.dao;


import com.viontech.keliu.model.FaceData;
import com.viontech.keliu.model.FlowData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2018-11-16
 * @description
 */
@Repository
public class SendDataDao {

    @Autowired
    private JdbcTemplate jdbcTemplate;


    // 精准客流数据
    /** 广场天精准客流数据 */
    private static final String FACE_PLAZA_DAY_DATA = "SELECT b.unid AS plaza_unid,countdate, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                              "FROM d_mall_day_face_recognition_sta AS d,b_mall AS b WHERE b.id=d.mall_id AND d.counttime BETWEEN ? AND ? AND b.unid=? ORDER BY modify_time DESC ";
    /** 广场小时精准客流数据 */
    private static final String FACE_PLAZA_HOUR_DATA = "SELECT b.unid AS plaza_unid,countdate,counttime, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                               "FROM d_mall_hour_face_recognition_sta AS d,b_mall AS b WHERE b.id=d.mall_id AND counttime BETWEEN ? AND ? AND b.unid=? ORDER BY modify_time DESC ";
    /** 监控点天精准客流数据 */
    private static final String FACE_GATE_DAY_DATA = "SELECT b.unid AS plaza_unid,g.unid AS gate_unid,countdate, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                             "FROM d_gate_day_face_recognition_sta AS d,b_mall AS b,b_gate AS g WHERE b.id=d.mall_id AND g.id=d.gate_id AND counttime BETWEEN ? AND ? AND b.unid=? ORDER BY modify_time DESC ";
    /** 监控点小时精准客流数据 */
    private static final String FACE_GATE_HOUR_DATA = "SELECT b.unid AS plaza_unid,g.unid AS gate_unid ,countdate,counttime, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                              "FROM d_gate_hour_face_recognition_sta AS d,b_mall AS b,b_gate AS g WHERE b.id=d.mall_id AND g.id=d.gate_id AND d.counttime BETWEEN ? AND ? AND b.unid=? ORDER BY modify_time DESC ";

    public List<FaceData> getFacePlazaDayData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(FACE_PLAZA_DAY_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FaceData.class));
    }

    public List<FaceData> getFacePlazaHourData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(FACE_PLAZA_HOUR_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FaceData.class));
    }

    public List<FaceData> getFaceGateDayData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(FACE_GATE_DAY_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FaceData.class));
    }

    public List<FaceData> getFaceGateHourData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(FACE_GATE_HOUR_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FaceData.class));
    }


    // 传统客流数据
    /** 广场天数据 */
    private static final String PLAZA_DAY_DATA = "SELECT mall.unid AS plaza_unid,dmdcd.countdate,dmdcd.innum,dmdcd.outnum,dmdcd.modify_time FROM d_mall_day_count_data dmdcd LEFT JOIN b_mall mall ON dmdcd.mall_id = mall.id WHERE dmdcd.countdate BETWEEN ? AND ? AND mall.unid = ?";
    /** 广场小时数据 */
    private static final String PLAZA_HOUR_DATA = "SELECT mall.unid AS plaza_unid,dmhcd.countdate,dmhcd.counttime,dmhcd.innum,dmhcd.outnum FROM d_mall_hour_count_data dmhcd LEFT JOIN b_mall mall ON dmhcd.mall_id = mall.id WHERE dmhcd.countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 广场分钟数据 */
    private static final String PLAZA_MINUTE_DATA = "SELECT mall.unid AS plaza_unid,dmmcd.countdate,dmmcd.counttime,dmmcd.innum,dmmcd.outnum FROM d_mall_minute_count_data dmmcd LEFT JOIN b_mall mall ON dmmcd.mall_id = mall.id WHERE dmmcd.countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 楼层天数据 */
    private static final String FLOOR_DAY_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,countdate,innum,outnum FROM d_floor_day_count_data dfdcd LEFT JOIN b_floor floor ON dfdcd.floor_id = floor.id LEFT JOIN b_mall mall ON dfdcd.mall_id = mall.id WHERE dfdcd.countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 楼层小时数据 */
    private static final String FLOOR_HOUR_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,countdate,counttime,innum,outnum FROM d_floor_hour_count_data dfhcd LEFT JOIN b_floor floor ON dfhcd.floor_id = floor.id LEFT JOIN b_mall mall ON dfhcd.mall_id = mall.id WHERE countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 区域天数据 */
    private static final String ZONE_DAY_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,zone.unid AS zone_unid,countdate,innum,outnum FROM d_zone_day_count_data dzdcd LEFT JOIN b_mall mall ON dzdcd.mall_id = mall.id LEFT JOIN b_floor floor ON dzdcd.floor_id = floor.id LEFT JOIN b_zone zone ON dzdcd.zone_id = zone.id WHERE dzdcd.countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 区域小时数据 */
    private static final String ZOND_HOUR_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,zone.unid AS zone_unid,countdate,counttime,innum,outnum FROM d_zone_hour_count_data dzhcd LEFT JOIN b_mall mall ON dzhcd.mall_id = mall.id LEFT JOIN b_floor floor ON dzhcd.floor_id = floor.id LEFT JOIN b_zone zone ON dzhcd.zone_id = zone.id WHERE dzhcd.countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 监控点天数据 */
    private static final String GATE_DAY_DATA = "SELECT mall.unid AS plaza_unid,gate.unid AS gate_unid,countdate,innum,outnum FROM d_gate_day_count_data dgdcd LEFT JOIN b_mall mall ON dgdcd.mall_id = mall.id LEFT JOIN b_gate gate ON dgdcd.gate_id = gate.id WHERE dgdcd.countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 监控点小时数据 */
    private static final String GATE_HOUR_DATA = "SELECT mall.unid AS plaza_unid,gate.unid AS gate_unid,countdate,counttime,innum,outnum FROM d_gate_hour_count_data dghcd LEFT JOIN b_mall mall ON dghcd.mall_id = mall.id LEFT JOIN b_gate gate ON dghcd.gate_id = gate.id WHERE dghcd.countdate BETWEEN ? AND ? AND mall.unid=?";
    /** 监控点分钟数据 */
    private static final String GATE_MINUTE_DATA = "SELECT mall.unid AS plaza_unid,gate.unid AS gate_unid,dgmcd.counttime,dgmcd.countdate,dgmcd.innum,dgmcd.outnum FROM d_gate_minute_count_data dgmcd LEFT JOIN b_mall mall ON dgmcd.mall_id = mall.id LEFT JOIN b_gate gate ON dgmcd.gate_id = gate.id WHERE dgmcd.countdate BETWEEN ? AND ? AND mall.unid=?";


    public List<FlowData> getPlazaDayData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(PLAZA_DAY_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getPlazaHourData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(PLAZA_HOUR_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getPlazaMinuteData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(PLAZA_MINUTE_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getFloorDayData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(FLOOR_DAY_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getFloorHourData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(FLOOR_HOUR_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getZoneDayData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(ZONE_DAY_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getZoneHourData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(ZOND_HOUR_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getGateDayData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(GATE_DAY_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getGateHourData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(GATE_HOUR_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    public List<FlowData> getGateMinuteData(Date begin, Date end, String unid) {
        return jdbcTemplate.query(GATE_MINUTE_DATA, new Object[]{begin, end, unid}, new BeanPropertyRowMapper<>(FlowData.class));
    }



}
