package com.viontech.keliu.dao;

import com.viontech.keliu.model.User;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

/**
 * @author 谢明辉
 * @createDate 2018-11-5
 * @description
 */
@Repository
@Slf4j
public class InitDao {

    @Autowired
    private JdbcTemplate template;

    public static final String FIND_ACCOUNT_ID = "SELECT account_id FROM s_user WHERE login_name = ?";

    public Integer getAccountId(User user) {
        try {
            return template.queryForObject(FIND_ACCOUNT_ID, new Object[]{user.getUsername()}, Integer.class);
        } catch (Exception e) {
            log.info("查询accountID 出错");
            return null;
        }
    }
}
