package com.viontech.keliu.dao;


import com.viontech.keliu.model.FaceData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;


@Repository
public class FaceDataDao {

    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String FACE_PLAZA_DAY_DATA = "SELECT b.unid AS plaza_unid,countdate, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                              "FROM d_mall_day_face_recognition_sta AS d,b_mall AS b WHERE b.id=d.mall_id AND d.modify_time>? ORDER BY modify_time DESC ";

    /**
     * 广场天精准客流
     *
     * @param modifyTime
     * @return
     */
    public List<FaceData> getFacePlazaDayData(Date modifyTime) {
        return jdbcTemplate.query(FACE_PLAZA_DAY_DATA, new Object[]{modifyTime}, new BeanPropertyRowMapper<>(FaceData.class));
    }

    private static final String FACE_PLAZA_HOUR_DATA = "SELECT b.unid AS plaza_unid,countdate,counttime, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                               "FROM d_mall_hour_face_recognition_sta AS d,b_mall AS b WHERE b.id=d.mall_id AND d.modify_time>? ORDER BY modify_time DESC ";

    /**
     * 广场小时精准客流
     *
     * @param modifyTime
     * @return
     */
    public List<FaceData> getFacePlazaHourData(Date modifyTime) {
        return jdbcTemplate.query(FACE_PLAZA_HOUR_DATA, new Object[]{modifyTime}, new BeanPropertyRowMapper<>(FaceData.class));
    }

    private static final String FACE_GATE_DAY_DATA = "SELECT b.unid AS plaza_unid,g.unid AS gate_unid,countdate, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                             "FROM d_gate_day_face_recognition_sta AS d,b_mall AS b,b_gate AS g WHERE b.id=d.mall_id AND g.id=d.gate_id AND d.modify_time>?  ORDER BY modify_time DESC ";

    /**
     * （广场级）出入口天精准客流
     *
     * @param modifyTime
     * @return
     */
    public List<FaceData> getFaceGateDayData(Date modifyTime) {
        return jdbcTemplate.query(FACE_GATE_DAY_DATA, new Object[]{modifyTime}, new BeanPropertyRowMapper<>(FaceData.class));
    }

    private static final String FACE_GATE_HOUR_DATA = "SELECT b.unid AS plaza_unid,g.unid AS gate_unid ,countdate,counttime, person_count AS totalnum,custom_count AS customer, male_count AS male,female_count AS female,male_stage AS maleAge,female_stage AS femaleAge,d.modify_time,new_custom_count AS newCustomer,new_male_count AS newMale,new_female_count AS newFemale,new_male_stage AS newMaleAge,new_female_stage AS newFemaleAge,regular_custom_count AS regularCustomer,regular_male_count AS regularMale,regular_female_count AS regularFemale,regular_male_stage AS regularMaleAge,regular_female_stage AS regularFemaleAge \n" +
                                                              "FROM d_gate_hour_face_recognition_sta AS d,b_mall AS b,b_gate AS g WHERE b.id=d.mall_id AND g.id=d.gate_id AND d.modify_time>?  ORDER BY modify_time DESC ";

    /**
     * （广场级）出入口小时精准客流
     *
     * @param modifyTime
     * @return
     */
    public List<FaceData> getFaceGateHourData(Date modifyTime) {
        return jdbcTemplate.query(FACE_GATE_HOUR_DATA, new Object[]{modifyTime}, new BeanPropertyRowMapper<>(FaceData.class));
    }
}
