package com.viontech.keliu.dao;

import com.viontech.keliu.Global;
import com.viontech.keliu.model.FlowData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * @author 谢明辉
 * @createDate 2018-10-23
 * @description
 */
@Repository
public class DataDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static final String PLAZA_DAY_DATA = "SELECT mall.unid AS plaza_unid,dmdcd.countdate,dmdcd.innum,dmdcd.outnum,dmdcd.modify_time FROM d_mall_day_count_data dmdcd LEFT JOIN b_mall mall ON dmdcd.mall_id = mall.id WHERE dmdcd.modify_time >= ? AND mall.account_id=? ORDER BY dmdcd.modify_time DESC";
    private static final String PLAZA_HOUR_DATA = "SELECT mall.unid AS plaza_unid,dmhcd.countdate,dmhcd.counttime,dmhcd.innum,dmhcd.outnum,dmhcd.modify_time FROM d_mall_hour_count_data dmhcd LEFT JOIN b_mall mall ON dmhcd.mall_id = mall.id WHERE dmhcd.countdate >= ? AND dmhcd.modify_time >? AND mall.account_id=? ORDER BY dmhcd.modify_time DESC ";
    private static final String PLAZA_MINUTE_DATA = "SELECT mall.unid AS plaza_unid,dmmcd.countdate,dmmcd.counttime,dmmcd.innum,dmmcd.outnum,dmmcd.modify_time FROM d_mall_minute_count_data dmmcd LEFT JOIN b_mall mall ON dmmcd.mall_id = mall.id WHERE dmmcd.modify_time >= ? AND mall.account_id=? ORDER BY dmmcd.modify_time DESC";

    private static final String FLOOR_DAY_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,countdate,innum,outnum,dfdcd.modify_time FROM d_floor_day_count_data dfdcd LEFT JOIN b_floor floor ON dfdcd.floor_id = floor.id LEFT JOIN b_mall mall ON dfdcd.mall_id = mall.id WHERE dfdcd.modify_time > ? AND mall.account_id=? ORDER BY dfdcd.modify_time DESC";
    private static final String FLOOR_HOUR_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,countdate,counttime,innum,outnum,dfhcd.modify_time FROM d_floor_hour_count_data dfhcd LEFT JOIN b_floor floor ON dfhcd.floor_id = floor.id LEFT JOIN b_mall mall ON dfhcd.mall_id = mall.id WHERE countdate >=? AND dfhcd.modify_time > ? AND mall.account_id=? ORDER BY dfhcd.modify_time DESC";

    private static final String ZONE_DAY_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,zone.unid AS zone_unid,countdate,innum,outnum,dzdcd.modify_time FROM d_zone_day_count_data dzdcd LEFT JOIN b_mall mall ON dzdcd.mall_id = mall.id LEFT JOIN b_floor floor ON dzdcd.floor_id = floor.id LEFT JOIN b_zone zone ON dzdcd.zone_id = zone.id WHERE dzdcd.modify_time >? AND mall.account_id=? ORDER BY dzdcd.modify_time DESC ";
    private static final String ZONE_HOUR_DATA = "SELECT mall.unid AS plaza_unid,floor.unid AS floor_unid,zone.unid AS zone_unid,countdate,counttime,innum,outnum,dzhcd.modify_time FROM d_zone_hour_count_data dzhcd LEFT JOIN b_mall mall ON dzhcd.mall_id = mall.id LEFT JOIN b_floor floor ON dzhcd.floor_id = floor.id LEFT JOIN b_zone zone ON dzhcd.zone_id = zone.id WHERE dzhcd.modify_time >? AND dzhcd.countdate>? AND mall.account_id=? ORDER BY dzhcd.modify_time DESC";

    private static final String GATE_DAY_DATA = "SELECT mall.unid AS plaza_unid,gate.unid AS gate_unid,countdate,innum,outnum,dgdcd.modify_time FROM d_gate_day_count_data dgdcd LEFT JOIN b_mall mall ON dgdcd.mall_id = mall.id LEFT JOIN b_gate gate ON dgdcd.gate_id = gate.id WHERE dgdcd.counttime >= ? AND dgdcd.modify_time > ? AND mall.account_id=? ORDER BY dgdcd.modify_time DESC";
    private static final String GATE_HOUR_DATA = "SELECT mall.unid AS plaza_unid,gate.unid AS gate_unid,countdate,counttime,innum,outnum,dghcd.modify_time FROM d_gate_hour_count_data dghcd LEFT JOIN b_mall mall ON dghcd.mall_id = mall.id LEFT JOIN b_gate gate ON dghcd.gate_id = gate.id WHERE dghcd.counttime >= ? AND dghcd.modify_time > ? AND mall.account_id=? ORDER BY dghcd.modify_time DESC";
    private static final String GATE_MINUTE_DATA = "SELECT mall.unid AS plaza_unid,gate.unid AS gate_unid,dgmcd.counttime,dgmcd.countdate,dgmcd.innum,dgmcd.outnum,dgmcd.modify_time FROM d_gate_minute_count_data dgmcd LEFT JOIN b_mall mall ON dgmcd.mall_id = mall.id LEFT JOIN b_gate gate ON dgmcd.gate_id = gate.id WHERE dgmcd.counttime >= ? AND dgmcd.modify_time > ? AND mall.account_id=? ORDER BY dgmcd.modify_time DESC";

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 广场天数据
     */
    public List<FlowData> getPlazaDayData(Date modifyTime) {
        return jdbcTemplate.query(PLAZA_DAY_DATA, new Object[]{modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 广场小时数据
     */
    public List<FlowData> getPlazaHourData(Date modifyTime) {
        Date countDate = new Date(modifyTime.getTime() - Global.DAY * 7L);
        return jdbcTemplate.query(PLAZA_HOUR_DATA, new Object[]{countDate, modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 广场十分钟数据
     */
    public List<FlowData> getPlazaMinuteData(Date modifyTime) {
        return jdbcTemplate.query(PLAZA_MINUTE_DATA, new Object[]{modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 广场级出入口十分钟数据
     */
    public List<FlowData> getGateMinuteData(Date modifyTime) {
        Date countDate = new Date(modifyTime.getTime() - Global.DAY * 7L);
        return jdbcTemplate.query(GATE_MINUTE_DATA, new Object[]{countDate, modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 楼层天数据
     */
    public List<FlowData> getFloorDayData(Date modifyTime) {
        return jdbcTemplate.query(FLOOR_DAY_DATA, new Object[]{modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 楼层小时数据
     */
    public List<FlowData> getFloorHourData(Date modifyTime) {
        Date countDate = new Date(modifyTime.getTime() - Global.DAY * 7L);
        return jdbcTemplate.query(FLOOR_HOUR_DATA, new Object[]{countDate, modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 店铺天数据
     */
    public List<FlowData> getZoneDayData(Date modifyTime) {
        return jdbcTemplate.query(ZONE_DAY_DATA, new Object[]{modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 店铺小时数据
     */
    public List<FlowData> getZoneHourData(Date modifyTime) {
        Date countDate = new Date(modifyTime.getTime() - Global.DAY * 7L);
        return jdbcTemplate.query(ZONE_HOUR_DATA, new Object[]{countDate, modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 出入口天数据
     */
    public List<FlowData> getGateDayData(Date modifyTime) {
        Date countDate = new Date(modifyTime.getTime() - Global.DAY * 7L);
        return jdbcTemplate.query(GATE_DAY_DATA, new Object[]{countDate, modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }

    /**
     * @param modifyTime
     * @return java.util.List<com.viontech.keliu.model.FlowData>
     * @createDate 2018-10-23
     * @description 出入口小时数据
     */
    public List<FlowData> getGateHourData(Date modifyTime) {
        Date countDate = new Date(modifyTime.getTime() - Global.DAY * 7L);
        return jdbcTemplate.query(GATE_HOUR_DATA, new Object[]{countDate, modifyTime,Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(FlowData.class));
    }
}
