package com.viontech.keliu.dao;


import com.viontech.keliu.Global;
import com.viontech.keliu.model.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @author 谢明辉
 * @createDate 2018-10-23
 * @description
 */
@Repository
public class AccountDao {

    @Autowired
    private JdbcTemplate jdbcTemplate;


    private static final String GET_PLAZA_ACCOUNT = "SELECT name AS plaza_name,unid AS plaza_unid,city_id AS plaza_city,longitude AS plaza_lng,latitude AS plaza_lat,status FROM b_mall WHERE account_id=?";


    public List<Plaza> getPlaza() {
        return jdbcTemplate.query(GET_PLAZA_ACCOUNT, new Object[]{Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(Plaza.class));
    }

    private static final String GET_FLOOR_ACCOUNT = "SELECT floor.name AS floor_name,floor.unid AS floor_unid,mall.status AS status,mall.unid AS plaza_unid FROM b_floor AS floor,b_mall AS mall WHERE floor.mall_id=mall.id AND mall.account_id=?";

    public List<Floor> getFloor() {
        return jdbcTemplate.query(GET_FLOOR_ACCOUNT, new Object[]{Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(Floor.class));
    }

    private static final String GET_ZONE_ACCOUNT = "SELECT zone.unid AS zone_unid,mall.unid AS plaza_unid,floor.unid AS floor_unid,zone.name AS zone_name,zone.location_no AS location_no,zone.format_id AS format_id,zone.type AS zone_type,zone.status AS status FROM b_zone AS zone LEFT JOIN b_mall AS mall ON zone.mall_id=mall.id LEFT JOIN b_floor AS floor ON zone.floor_id=floor.id WHERE mall.account_id=?";

    public List<Zone> getZone() {
        return jdbcTemplate.query(GET_ZONE_ACCOUNT, new Object[]{Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(Zone.class));
    }

    private static final String GET_GATE_ACCOUNT = "SELECT mall.unid AS plaza_unid,f.unid AS floor_unid,gate.unid AS gate_unid,gate.name AS gate_name,is_mall_gate,is_has_face,gate.x AS location_x,gate.y AS location_y,gate.status FROM b_gate gate LEFT JOIN b_mall mall ON gate.mall_id = mall.id LEFT JOIN b_floor f ON gate.floor_id = f.id WHERE mall.account_id=?";

    public List<Gate> getGate() {
        return jdbcTemplate.query(GET_GATE_ACCOUNT, new Object[]{Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(Gate.class));
    }

    private static final String GET_FLOOR_GATE_ACCOUNT = "SELECT gate.plaza_unid,floor.unid AS floor_unid,gate.gate_unid,rfg.type AS direction,0 AS status FROM r_floor_gate rfg LEFT JOIN b_floor floor ON rfg.floor_id=floor.id LEFT JOIN (SELECT b_gate.id,b_gate.unid AS gate_unid,b_mall.unid AS plaza_unid FROM b_gate LEFT JOIN b_mall ON b_gate.mall_id = b_mall.id) gate ON rfg.gate_id=gate.id WHERE account_id=? AND gate_unid IS NOT NULL ";

    public List<Relation> getFloorGate() {
        return jdbcTemplate.query(GET_FLOOR_GATE_ACCOUNT, new Object[]{Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(Relation.class));
    }

    private static final String GET_ZONE_GATE_ACCOUNT = "SELECT zone.unid AS zone_unid,gate.unid AS gate_unid,rzg.type AS direction FROM r_zone_gate rzg LEFT JOIN b_gate gate ON rzg.gate_id = gate.id LEFT JOIN b_zone zone ON rzg.zone_id = zone.id WHERE gate.account_id=? AND gate.unid IS NOT NULL";

    public List<Relation> getZoneGate() {
        return jdbcTemplate.query(GET_ZONE_GATE_ACCOUNT, new Object[]{Global.ACCOUNT_ID}, new BeanPropertyRowMapper<>(Relation.class));
    }
}
