package com.viontech.keliu.controller;


import com.viontech.keliu.dao.AccountDao;
import com.viontech.keliu.job.SendDataSyncJob;
import com.viontech.keliu.vo.Form;
import com.viontech.keliu.vo.ResultVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;


@RestController
public class SendController implements WebMvcConfigurer {

    @Autowired
    private AccountDao accountDao;
    @Autowired
    private SendDataSyncJob sendDataSyncJob;
    @Value("${face:false}")
    private boolean face;

    @PostMapping("/send")
    public Object send(@RequestBody Form form) {
        try {
            if (face) {
                sendDataSyncJob.sendExactnessData(form.getStartTime(), form.getEndTime(), form.getUnid());
            }
            sendDataSyncJob.sendCountData(form.getStartTime(), form.getEndTime(), form.getUnid());
        } catch (Exception e) {
            e.printStackTrace();
            return new ResultVO(500, "出错了");
        }

        return new ResultVO(200, "成功");
    }

    @GetMapping("/getList")
    public Object get() {
        return accountDao.getPlaza();
    }

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
        .allowedOrigins("*")
        .allowedMethods("GET", "POST")
        .allowCredentials(false).maxAge(3600);
    }
}
