package com.viontech.keliu;


import com.viontech.keliu.dao.InitDao;
import com.viontech.keliu.job.DataSyncJob;
import com.viontech.keliu.job.FaceDataSyncJob;
import com.viontech.keliu.job.OrgSyncJob;
import com.viontech.keliu.model.User;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;


@EnableAutoConfiguration
@SpringBootApplication
@ComponentScan(basePackages = {"com.viontech.*"})
@Slf4j
@EnableScheduling
public class Application implements CommandLineRunner {

    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }

    @Autowired
    private User user;
    @Autowired
    private OrgSyncJob orgSyncJob;
    @Autowired
    private DataSyncJob dataSyncJob;
    @Autowired
    private FaceDataSyncJob faceSyncJob;
    @Autowired
    private InitDao initDao;

    @Override
    public void run(String... args) throws Exception {
        Global.ACCOUNT_ID = initDao.getAccountId(user);
        if (Global.ACCOUNT_ID == null) {
            log.error("accountId为空，程序结束 user={}", user.toString());
            System.exit(1);
        }
    }

    /**
     * @param
     * @return void
     * @createDate 2018-10-23
     * @description 组织关系定时任务
     */
    @Scheduled(fixedDelay = 1000 * 60 * 60 * 24, initialDelay = 1000 * 10)//cron = "* */1 * * * ?"
    public void org() {
        try {
            long begin = System.currentTimeMillis();
            orgSyncJob.execute();
            long end = System.currentTimeMillis();
            log.info("[组织关系][TIME][{}]", (end - begin) / 1000L);
            // dataCountSyncJob.execute();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * @param
     * @return void
     * @createDate 2018-10-23
     * @description 数据定时任务
     */
    @Scheduled(fixedDelay = 1000 * 60 * 5, initialDelay = 1000 * 10)//cron = "* */1 * * * ?"
    public void startDataJob() {
        try {
            long begin = System.currentTimeMillis();
            dataSyncJob.execute();
            long end = System.currentTimeMillis();
            log.info("[数据上传][TIME]" + (end - begin) / 1000L);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Value("${face:false}")
    private boolean face;

    /**
     * @param
     * @return void
     * @createDate 2018-10-10
     * @description 精准客流定时任务
     */
    @Scheduled(fixedDelay = 1000 * 60 * 5, initialDelay = 1000 * 10)//cron = "* */1 * * * ?"
    public void startFaceJob() {
        if (face) {
            try {
                long begin = System.currentTimeMillis();
                faceSyncJob.execute();
                long end = System.currentTimeMillis();
                log.info("[精准客流][TIME]" + (end - begin) / 1000L);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
