/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service.impl;

import com.viontech.keliu.Global;
import com.viontech.keliu.dao.impl.DataCountDaoImpl;
import com.viontech.keliu.model.AccountDay;
import com.viontech.keliu.model.AccountGateMinute;
import com.viontech.keliu.model.AccountHour;
import com.viontech.keliu.model.AccountMinute;
import com.viontech.keliu.model.FloorDay;
import com.viontech.keliu.model.FloorHour;
import com.viontech.keliu.model.GateDay;
import com.viontech.keliu.model.GateHour;
import com.viontech.keliu.model.ShopDay;
import com.viontech.keliu.model.ShopHour;
import com.viontech.keliu.service.adapter.DataCountService;
import com.viontech.keliu.utils.HttpUtil;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataCountServiceImpl
implements DataCountService {
    @Autowired
    private DataCountDaoImpl dataCountDaoImpl;
    private Date lastSuccessTime = new Date();
    private final Logger logger = LoggerFactory.getLogger(DataCountServiceImpl.class);
    Date account_day_modifyTime = null;
    Date account_hour_modifyTime = null;
    Date account_minute_modifyTime = null;
    Date account_gate_minute_modifyTime = null;
    Date floor_day_modifyTime = null;
    Date floor_hour_modifyTime = null;
    Date shop_day_modifyTime = null;
    Date gate_day_modifyTime = null;
    Date shop_hour_modifyTime = null;
    Date gate_hour_modifyTime = null;
    long begin;
    long end;
    Date now = null;

    public DataCountServiceImpl() {
        LocalDate localDate = LocalDate.now();
        this.now = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public List<AccountDay> account_day_query() throws IOException {
        if (this.account_day_modifyTime == null) {
            this.account_day_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.account_day_query(this.account_day_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u5e7f\u573a\u5929\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/plazaDay", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.account_day_modifyTime = ((AccountDay)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1aaccount_day_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u5e7f\u573a\u5929\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<AccountHour> account_hour_query() throws IOException {
        if (this.account_hour_modifyTime == null) {
            this.account_hour_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.account_hour_query(this.account_hour_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u5e7f\u573a\u5c0f\u65f6\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/plazaHour", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.account_hour_modifyTime = ((AccountHour)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1aaccount_hour_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u5e7f\u573a\u5c0f\u65f6\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<AccountMinute> account_minute_query() throws IOException {
        if (this.account_minute_modifyTime == null) {
            this.account_minute_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.account_minute_query(this.account_minute_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u5e7f\u573a\u5341\u5206\u949f\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/plazaTenMins", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.account_minute_modifyTime = ((AccountMinute)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1aaccount_minute_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u5e7f\u573a\u5341\u5206\u949f\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<AccountGateMinute> account_gate_minute_query() throws IOException {
        if (this.account_gate_minute_modifyTime == null) {
            this.account_gate_minute_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.account_gate_minute_query(this.account_gate_minute_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u5e7f\u573a\u51fa\u5165\u53e3\u5341\u5206\u949f\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            JSONObject object = new JSONObject((Object)tempList);
            this.logger.info(object.toString());
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/gateTenMins", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.account_gate_minute_modifyTime = ((AccountGateMinute)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1aaccount_gate_minute_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u5e7f\u573a\u51fa\u5165\u53e3\u5341\u5206\u949f\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<FloorDay> floor_day_query() throws IOException {
        if (this.floor_day_modifyTime == null) {
            this.floor_day_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.floor_day_query(this.floor_day_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u697c\u5c42\u5929\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/floorDay", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.floor_day_modifyTime = ((FloorDay)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1afloor_day_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u697c\u5c42\u5929\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<FloorHour> floor_hour_query() throws IOException {
        if (this.floor_hour_modifyTime == null) {
            this.floor_hour_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.floor_hour_query(this.floor_hour_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u697c\u5c42\u5c0f\u65f6\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/floorHour", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.floor_hour_modifyTime = ((FloorHour)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1afloor_hour_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u697c\u5c42\u5c0f\u65f6\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<ShopDay> shop_day_query() throws IOException {
        if (this.shop_day_modifyTime == null) {
            this.shop_day_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.shop_day_query(this.shop_day_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u5e97\u94fa\u5929\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/zoneDay", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.shop_day_modifyTime = ((ShopDay)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1ashop_day_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u5e97\u94fa\u5929\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<ShopHour> shop_hour_query() throws IOException {
        if (this.shop_hour_modifyTime == null) {
            this.shop_hour_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.shop_hour_query(this.shop_hour_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u5e97\u94fa\u5c0f\u65f6\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/zoneHour", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.shop_hour_modifyTime = ((ShopHour)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1ashop_hour_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u5e97\u94fa\u5c0f\u65f6\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<GateDay> gate_day_query() throws IOException {
        if (this.gate_day_modifyTime == null) {
            this.gate_day_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.gate_day_query(this.gate_day_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u51fa\u5165\u53e3\u5929\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            JSONObject object = new JSONObject((Object)tempList);
            this.logger.info(object.toString());
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/gateDay", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.gate_day_modifyTime = ((GateDay)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1agate_day_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u51fa\u5165\u53e3\u5929\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public List<GateHour> gate_hour_query() throws IOException {
        if (this.gate_hour_modifyTime == null) {
            this.gate_hour_modifyTime = this.now;
        }
        this.begin = System.currentTimeMillis();
        List tempList = this.dataCountDaoImpl.gate_hour_query(this.gate_hour_modifyTime);
        this.end = System.currentTimeMillis();
        this.logger.info("\u51fa\u5165\u53e3\u5c0f\u65f6\u6570\u636e\u67e5\u8be2,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        if (tempList.size() > 0) {
            JSONObject object = new JSONObject((Object)tempList);
            this.logger.info(object.toString());
            this.begin = System.currentTimeMillis();
            HttpUtil.send((String)"/api/v1/passenger/gateHour", (List)tempList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.gate_hour_modifyTime = ((GateHour)tempList.get(0)).getModifytime();
                    this.lastSuccessTime = new Date();
                } else {
                    this.logger.warn("\u8c03\u7528\u5931\u8d25\uff1agate_hour_query,code:" + message.getMsgCode() + ",info:" + message.getMsgInfo());
                }
            }, (String)Global.atoken);
            this.end = System.currentTimeMillis();
            this.logger.info("\u51fa\u5165\u53e3\u5c0f\u65f6\u6570\u636e\u4e0a\u4f20,[TIME][{}]", (Object)((this.end - this.begin) / 1000L));
        }
        return tempList;
    }

    public Date getLastSuccessTime() {
        return this.lastSuccessTime;
    }

    public void setLastSuccessTime(Date lastSuccessTime) {
        this.lastSuccessTime = lastSuccessTime;
    }
}

