/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.job;

import com.viontech.keliu.Global;
import com.viontech.keliu.job.DataCountSyncJob;
import com.viontech.keliu.model.User;
import com.viontech.keliu.service.impl.AccountServiceImpl;
import com.viontech.keliu.utils.HttpUtil;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrgSyncJob {
    @Autowired
    private AccountServiceImpl accountServiceImpl;
    private final Logger logger = LoggerFactory.getLogger(OrgSyncJob.class);
    @Autowired
    User user;
    private boolean isSuccess = false;
    private int count = 0;

    public void execute() throws IOException {
        DataCountSyncJob.login((User)this.user);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.accountServiceImpl.resource_query().size() > 0) {
            this.logger.info("\u5e7f\u573a\u7ec4\u7ec7\u5173\u7cfb\u5f00\u59cb\u8bf7\u6c42");
            List plazaList = this.accountServiceImpl.p_query();
            HttpUtil.send((String)"/api/v1/base/plazaInfo", (List)plazaList, message -> {
                Integer code = message.getMsgCode();
                if (code == 200 || code == 500) {
                    this.isSuccess = true;
                    ++this.count;
                }
            }, (String)Global.atoken);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.logger.info("\u697c\u5c42\u7ec4\u7ec7\u5173\u7cfb\u5f00\u59cb\u8bf7\u6c42");
            List floorList = this.accountServiceImpl.f_query();
            HttpUtil.send((String)"/api/v1/base/floorInfo", (List)floorList, (Consumer)this.getMessageConsumer(), (String)Global.atoken);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.logger.info("\u5e97\u94fa\u7ec4\u7ec7\u5173\u7cfb\u5f00\u59cb\u8bf7\u6c42");
            List zoneList = this.accountServiceImpl.z_query();
            HttpUtil.send((String)"/api/v1/base/zoneInfo", (List)zoneList, (Consumer)this.getMessageConsumer(), (String)Global.atoken);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.logger.info("\u51fa\u5165\u53e3\u7ec4\u7ec7\u5173\u7cfb\u5f00\u59cb\u8bf7\u6c42");
            List gateList = this.accountServiceImpl.g_query();
            HttpUtil.send((String)"/api/v1/base/gateInfo", (List)gateList, (Consumer)this.getMessageConsumer(), (String)Global.atoken);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.logger.info("\u697c\u5c42\u51fa\u5165\u53e3\u7ec4\u7ec7\u5173\u7cfb\u5f00\u59cb\u8bf7\u6c42");
            List floorGateList = this.accountServiceImpl.fg_query();
            HttpUtil.send((String)"/api/v1/base/floorGateRelation", (List)floorGateList, (Consumer)this.getMessageConsumer(), (String)Global.atoken);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.logger.info("\u5e97\u94fa\u51fa\u5165\u53e3\u7ec4\u7ec7\u5173\u7cfb\u5f00\u59cb\u8bf7\u6c42");
            List zoneGateList = this.accountServiceImpl.zg_query();
            HttpUtil.send((String)"/api/v1/base/zoneGateRelation", (List)zoneGateList, (Consumer)this.getMessageConsumer(), (String)Global.atoken);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.isSuccess && this.count >= 6) {
                this.count = 0;
                this.accountServiceImpl.resource_update();
            }
        } else {
            this.logger.info("\u7ec4\u7ec7\u5173\u7cfb\u65e0\u53d8\u5316\u4e0d\u7528\u4e0a\u4f20");
        }
    }

    private Consumer<HttpUtil.Message> getMessageConsumer() {
        return message -> {
            message.getMsgInfo();
            Integer code = message.getMsgCode();
            if (code == 200 || code == 500) {
                ++this.count;
            } else {
                this.logger.warn("\u7ec4\u7ec7\u5173\u7cfb\u4e0a\u4f20\u5931\u8d25\uff0c" + message.getMsgInfo());
            }
        };
    }

    public void accountSync() {
        System.out.println("OrgSyncJob.accountSync");
    }

    public void mallSync() {
        System.out.println("OrgSyncJob.mallSync");
    }
}

