/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu;

import com.viontech.keliu.job.DataCountSyncJob;
import com.viontech.keliu.job.OrgSyncJob;
import com.viontech.keliu.model.User;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@EnableAutoConfiguration
@SpringBootApplication
@ComponentScan(basePackages={"com.viontech.*"})
@EnableScheduling
public class Application
implements CommandLineRunner {
    Logger logger = LoggerFactory.getLogger(Application.class);
    @Autowired
    User user;
    @Autowired
    private OrgSyncJob orgSyncJob;
    @Autowired
    private DataCountSyncJob dataCountSyncJob;

    public static void main(String[] args) {
        try {
            SpringApplication.run(Application.class, (String[])args);
            new CountDownLatch(1).await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(String ... args) throws Exception {
        System.out.println("\u7a0b\u5e8f\u5df2\u542f\u52a8");
    }

    @Scheduled(fixedDelay=600000L, initialDelay=1000L)
    public void startJob() {
        this.logger.info("\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u4efb\u52a1\u5f00\u59cb");
        try {
            long begin = System.currentTimeMillis();
            this.orgSyncJob.execute();
            long end = System.currentTimeMillis();
            this.logger.info("\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u4efb\u52a1\u7ed3\u675f,[\u7ec4\u7ec7\u5173\u7cfb][TIME][{}]", (Object)((end - begin) / 1000L));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u7ec4\u7ec7\u5173\u7cfb\u5b9a\u65f6\u5904\u7406Job\u53d1\u751f\u5f02\u5e38,\u7cfb\u7edf\u9000\u51fa", (Throwable)e);
        }
    }

    @Scheduled(fixedDelay=600000L, initialDelay=20000L)
    public void startDataJob() {
        this.logger.info("\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb");
        try {
            long begin = System.currentTimeMillis();
            this.dataCountSyncJob.execute();
            long end = System.currentTimeMillis();
            this.logger.info("\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f\uff0c[\u6570\u636e\u4e0a\u4f20][TIME]{}", (Object)((end - begin) / 1000L));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u6570\u636e\u4e0a\u4f20\u5b9a\u65f6\u5904\u7406Job\u53d1\u751f\u5f02\u5e38,\u7cfb\u7edf\u9000\u51fa", (Throwable)e);
        }
    }
}

