package com.viontech.keliu.service.impl;

import com.viontech.keliu.Application;
import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.dao.impl.DataCountDaoImpl;
import com.viontech.keliu.model.*;
import com.viontech.keliu.service.adapter.DataCountService;
import com.viontech.keliu.utils.HttpUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.time.*;
import java.util.Date;
import java.util.List;

@Service
public class DataCountServiceImpl implements DataCountService {

    @Autowired
    private DataCountDaoImpl dataCountDaoImpl;
    private Date lastSuccessTime =new Date();//记录数据发送时间
    private final Logger logger = LoggerFactory.getLogger(DataCountServiceImpl.class);
    //记录数据的增量时间
    Date account_day_modifyTime=null;
    Date account_hour_modifyTime=null;
    Date account_minute_modifyTime=null;
    Date account_gate_minute_modifyTime=null;
    Date floor_day_modifyTime=null;
    Date floor_hour_modifyTime=null;
    Date shop_day_modifyTime=null;
    Date gate_day_modifyTime=null;
    Date shop_hour_modifyTime=null;
    Date gate_hour_modifyTime=null;

    //记录方法执行的时间
    long begin;
    long end;
    //第一次初始化默认数据时间
    Date now = null;
    {
        LocalDate localDate = LocalDate.now();
        now = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
    @Override
    public List<AccountDay> account_day_query() throws IOException {

        if(account_day_modifyTime==null) {
            account_day_modifyTime=now;
        }
        begin = System.currentTimeMillis();
        List<AccountDay> tempList = dataCountDaoImpl.account_day_query(account_day_modifyTime);
        end = System.currentTimeMillis();
        logger.info("广场天数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.PLAZE_DAY_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    //更新数据发送时间
                    account_day_modifyTime = tempList.get(0).getModifytime();

                    //更新请求成功时间
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：account_day_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("广场天数据上传,[TIME][{}]",(end-begin)/1000L);
        }

        return tempList;
    }

    @Override
    public List<AccountHour> account_hour_query() throws IOException {
        if(account_hour_modifyTime==null)
            account_hour_modifyTime=now;

        begin = System.currentTimeMillis();
        List<AccountHour> tempList=dataCountDaoImpl.account_hour_query(account_hour_modifyTime);
        end = System.currentTimeMillis();
        logger.info("广场小时数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            //messcode：200成功，500失败
            begin = System.currentTimeMillis();
            HttpUtil.send(URLConstants.PLAZE_HOUR_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    account_hour_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：account_hour_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("广场小时数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

    @Override
    public List<AccountMinute> account_minute_query() throws IOException {
        if(account_minute_modifyTime==null)
            account_minute_modifyTime=now;
        begin = System.currentTimeMillis();
        List<AccountMinute> tempList=dataCountDaoImpl.account_minute_query(account_minute_modifyTime);
        end = System.currentTimeMillis();
        logger.info("广场十分钟数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.PLAZE_TEN_MINUTE_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    account_minute_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：account_minute_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("广场十分钟数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

    @Override
    public List<AccountGateMinute> account_gate_minute_query() throws IOException {

        if(account_gate_minute_modifyTime==null)
            account_gate_minute_modifyTime=now;
        begin = System.currentTimeMillis();
        List<AccountGateMinute> tempList=dataCountDaoImpl.account_gate_minute_query(account_gate_minute_modifyTime);
        end = System.currentTimeMillis();
        logger.info("广场出入口十分钟数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0){
            JSONObject object = new JSONObject(tempList);
            logger.info(object.toString());
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.PLAZE_GATE_TEN_MINUTE_URL,tempList,(message) ->{
                Integer code = message.getMsgCode();
                if ((code == 200 || code==500)) {
                    account_gate_minute_modifyTime=tempList.get(0).getModifytime();
                    lastSuccessTime =new Date();
                }else{
                    logger.warn("调用失败：account_gate_minute_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            },Global.atoken);
            end = System.currentTimeMillis();
            logger.info("广场出入口十分钟数据上传,[TIME][{}]",(end-begin)/1000L);
        }

        return tempList;
    }

    @Override
    public List<FloorDay> floor_day_query() throws IOException {

        if(floor_day_modifyTime==null)
            floor_day_modifyTime=now;
        begin = System.currentTimeMillis();
        List<FloorDay> tempList=dataCountDaoImpl.floor_day_query(floor_day_modifyTime);
        end = System.currentTimeMillis();
        logger.info("楼层天数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.FLOOR_DAY_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    floor_day_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：floor_day_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("楼层天数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

    @Override
    public List<FloorHour> floor_hour_query() throws IOException {

        if(floor_hour_modifyTime==null)
            floor_hour_modifyTime=now;
        begin = System.currentTimeMillis();
        List<FloorHour> tempList=dataCountDaoImpl.floor_hour_query(floor_hour_modifyTime);
        end = System.currentTimeMillis();
        logger.info("楼层小时数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.FLOOR_HOUR_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    floor_hour_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：floor_hour_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("楼层小时数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

    @Override
    public List<ShopDay> shop_day_query() throws IOException {

        if(shop_day_modifyTime==null)
            shop_day_modifyTime=now;
        begin = System.currentTimeMillis();
        List<ShopDay> tempList=dataCountDaoImpl.shop_day_query(shop_day_modifyTime);
        end = System.currentTimeMillis();
        logger.info("店铺天数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.ZONE_DAY_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    shop_day_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：shop_day_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("店铺天数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

    @Override
    public List<ShopHour> shop_hour_query() throws IOException {

        if(shop_hour_modifyTime==null)
            shop_hour_modifyTime=now;
        begin = System.currentTimeMillis();
        List<ShopHour> tempList=dataCountDaoImpl.shop_hour_query(shop_hour_modifyTime);
        end = System.currentTimeMillis();
        logger.info("店铺小时数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.ZONE_HOUR_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    shop_hour_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：shop_hour_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("店铺小时数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

    @Override
    public List<GateDay> gate_day_query() throws IOException {

        if(gate_day_modifyTime==null)
            gate_day_modifyTime=now;
        begin = System.currentTimeMillis();
        List<GateDay> tempList=dataCountDaoImpl.gate_day_query(gate_day_modifyTime);
        end = System.currentTimeMillis();
        logger.info("出入口天数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            JSONObject object = new JSONObject(tempList);
            logger.info(object.toString());
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.GATE_DAY_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    gate_day_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：gate_day_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("出入口天数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

    @Override
    public List<GateHour> gate_hour_query() throws IOException {

        if(gate_hour_modifyTime==null)
            gate_hour_modifyTime=now;
        begin = System.currentTimeMillis();
        List<GateHour> tempList=dataCountDaoImpl.gate_hour_query(gate_hour_modifyTime);
        end = System.currentTimeMillis();
        logger.info("出入口小时数据查询,[TIME][{}]",(end-begin)/1000L);

        if(tempList.size() > 0) {
            JSONObject object = new JSONObject(tempList);
            logger.info(object.toString());
            begin = System.currentTimeMillis();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.GATE_HOUR_URL, tempList, (message) -> {
                Integer code = message.getMsgCode();
                if ((code == 200 || code == 500)) {
                    gate_hour_modifyTime = tempList.get(0).getModifytime();
                    lastSuccessTime = new Date();
                } else {
                    logger.warn("调用失败：gate_hour_query,code:" + message.getMsgCode()+",info:"+message.getMsgInfo());
                }
            }, Global.atoken);
            end = System.currentTimeMillis();
            logger.info("出入口小时数据上传,[TIME][{}]",(end-begin)/1000L);
        }
        return tempList;
    }

//    public Consumer<HttpUtil.Message> getMessageConsumer(int num) {
//        return (message) ->{
//            message.getMsgInfo();
//            Integer code = message.getMsgCode();
//            if (code != 200) {
//                num=0;
//            }
//            System.out.println(message.getMsgInfo());
//        };
//    }


    public Date getLastSuccessTime() {
        return lastSuccessTime;
    }

    public void setLastSuccessTime(Date lastSuccessTime) {
        this.lastSuccessTime = lastSuccessTime;
    }
}
