package com.viontech.keliu.service.impl;

import com.viontech.keliu.dao.impl.AccountDaoImpl;
import com.viontech.keliu.model.*;
import com.viontech.keliu.service.adapter.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class AccountServiceImpl implements AccountService {

    @Autowired
    private AccountDaoImpl accountDaoImpl;

    @Override
    public List<Plaza> p_query() {
        List<Plaza> plazaList=accountDaoImpl.p_query();
        List<Plaza> resultPlazaList=new ArrayList<Plaza>();
        Plaza _plaza;
        for(Plaza temp:plazaList){
            _plaza=new Plaza();
            String remark=temp.getRemark();
            if(remark!=null && remark.indexOf(",")>0){
                String[] remarks= remark.split(",");
                if(remarks.length==3){
                    _plaza.setPlaza_city(remarks[0]);
                    _plaza.setPlaza_lat(remarks[1]);
                    _plaza.setPlaza_lng(remarks[2]);
                }else{
                    _plaza.setPlaza_city("1");
                    _plaza.setPlaza_lat("40.009586");
                    _plaza.setPlaza_lng("116.42661");
                }
            }else {
                _plaza.setPlaza_city("1");
                _plaza.setPlaza_lat("40.009586");
                _plaza.setPlaza_lng("116.42661");
            }

            _plaza.setPlaza_name(temp.getPlaza_name());
            _plaza.setPlaza_unid(temp.getPlaza_unid());
            _plaza.setStatus(temp.getStatus());

            resultPlazaList.add(_plaza);
        }
        return resultPlazaList;
    }

    @Override
    public List<Floor> f_query() {
        return accountDaoImpl.f_query();
    }

    @Override
    public List<Zone> z_query() {
        return accountDaoImpl.z_query();
    }
    @Override
    public List<Gate> g_query() {
        return accountDaoImpl.g_query();
    }
    @Override
    public List<ZoneGate> zg_query() {
        return accountDaoImpl.zg_query();
    }
    @Override
    public List<FloorGate> fg_query() {
        return accountDaoImpl.fg_query();
    }
    @Override
    public List<ResourceLog> resource_query(){
        return accountDaoImpl.resource_query();
    }
    @Override
    public int resource_update(){
        return accountDaoImpl.resource_update();
    }
}
