package com.viontech.keliu.job;


import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.model.*;
import com.viontech.keliu.service.impl.DataCountServiceImpl;
import com.viontech.keliu.service.impl.SendDataCountServiceImpl;
import com.viontech.keliu.utils.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Date;
import java.util.List;

@Component
public class SendDataCountSyncJob {
    Logger logger = LoggerFactory.getLogger(SendDataCountSyncJob.class);
    @Autowired
    private SendDataCountServiceImpl sendDataCountServiceImpl;
    @Autowired
    User user;
    public void sendEexecute(String PlazaId, Date Begin, Date End) throws IOException {
        logger.info("广场天开始请求");
        logger.info("==="+Begin);
        logger.info("==="+End);

        DataCountSyncJob.login(user);

        List<AccountDay> accountDayList= sendDataCountServiceImpl.account_day_query(PlazaId,Begin,End);

        logger.info("==="+accountDayList.size());

        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.PLAZE_DAY_URL,accountDayList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("广场小时开始请求");
        List<AccountHour> accountHourList= sendDataCountServiceImpl.account_hour_query(PlazaId,Begin,End);
        logger.info("==="+accountHourList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.PLAZE_HOUR_URL,accountHourList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("广场十分钟开始请求");
        List<AccountMinute> accountTenMinuteList= sendDataCountServiceImpl.account_minute_query(PlazaId,Begin,End);
        logger.info("==="+accountTenMinuteList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.PLAZE_TEN_MINUTE_URL,accountTenMinuteList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("广场级-出入口十分钟开始请求");
        List<AccountGateMinute> accountGateMinuteList= sendDataCountServiceImpl.account_gate_minute_query(PlazaId,Begin,End);
        logger.info("==="+accountGateMinuteList.size());

        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.PLAZE_GATE_TEN_MINUTE_URL,accountGateMinuteList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("楼层天开始请求");
        List<FloorDay> floorDayList= sendDataCountServiceImpl.floor_day_query(PlazaId,Begin,End);
        logger.info("==="+floorDayList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.FLOOR_DAY_URL,floorDayList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("楼层小时开始请求");
        List<FloorHour> floorHourList= sendDataCountServiceImpl.floor_hour_query(PlazaId,Begin,End);
        logger.info("==="+floorHourList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.FLOOR_HOUR_URL,floorHourList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("店铺天开始请求");
        List<ShopDay> shopDayList= sendDataCountServiceImpl.shop_day_query(PlazaId,Begin,End);
        logger.info("==="+shopDayList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.ZONE_DAY_URL,shopDayList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("店铺小时开始请求");
        List<ShopHour> zoneHourList= sendDataCountServiceImpl.shop_hour_query(PlazaId,Begin,End);
        logger.info("==="+zoneHourList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.ZONE_HOUR_URL,zoneHourList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("出入口天开始请求");
        List<GateDay> gateDayList= sendDataCountServiceImpl.gate_day_query(PlazaId,Begin,End);
        logger.info("==="+gateDayList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.GATE_DAY_URL,gateDayList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("出入口小时开始请求");
        List<GateHour> gateHourList= sendDataCountServiceImpl.gate_hour_query(PlazaId,Begin,End);
        logger.info("==="+gateHourList.size());
        //messcode：200成功，500失败
        HttpUtil.send(URLConstants.GATE_HOUR_URL,gateHourList,(message) ->{
            logger.info("code:"+message.getMsgInfo()+"/info:"+message.getMsgInfo());
        },Global.atoken);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }


    public void accountSync(){
        logger.info("OrgSyncJob.accountSync");
    }

    public void mallSync(){
        logger.info("OrgSyncJob.mallSync");
    }

}
