package com.viontech.keliu.job;


import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.model.*;
import com.viontech.keliu.service.impl.AccountServiceImpl;
import com.viontech.keliu.model.Plaza;
import com.viontech.keliu.utils.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@Component
public class OrgSyncJob {

    @Autowired
    private AccountServiceImpl accountServiceImpl;

    private final Logger logger = LoggerFactory.getLogger(OrgSyncJob.class);

    @Autowired
    User user;
    private boolean isSuccess = false;
    private int count = 0;

    public void execute() throws IOException {
        DataCountSyncJob.login(user);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        if(accountServiceImpl.resource_query().size()>0){
           logger.info("广场组织关系开始请求");
            List<Plaza> plazaList= accountServiceImpl.p_query();
            //messcode：200成功，500失败
            HttpUtil.send(URLConstants.PLAZA_URL,plazaList, (message) ->{
                Integer code = message.getMsgCode();
                if (code == 200 || code==500) {
                    isSuccess = true;
                    count++;
                }
                },Global.atoken);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            logger.info("楼层组织关系开始请求");
            List<Floor> floorList= accountServiceImpl.f_query();
            HttpUtil.send(URLConstants.FLOOR_URL,floorList, getMessageConsumer(),Global.atoken);

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("店铺组织关系开始请求");
            List<Zone> zoneList= accountServiceImpl.z_query();
            HttpUtil.send(URLConstants.ZONE_URL,zoneList, getMessageConsumer(),Global.atoken);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("出入口组织关系开始请求");
            List<Gate> gateList= accountServiceImpl.g_query();
            HttpUtil.send(URLConstants.GATE_URL,gateList, getMessageConsumer(),Global.atoken);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("楼层出入口组织关系开始请求");
            List<FloorGate> floorGateList= accountServiceImpl.fg_query();
            HttpUtil.send(URLConstants.FLOOR_GATE_RELATION_URL,floorGateList, getMessageConsumer(),Global.atoken);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("店铺出入口组织关系开始请求");
            List<ZoneGate> zoneGateList= accountServiceImpl.zg_query();
            HttpUtil.send(URLConstants.ZONE_GATE_RELATION_URL,zoneGateList, getMessageConsumer(),Global.atoken);
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (isSuccess && count>=6) {
                count=0;
                accountServiceImpl.resource_update();
            }

        }else {
            logger.info("组织关系无变化不用上传");
        }
    }

    private Consumer<HttpUtil.Message> getMessageConsumer() {
        return (message) ->{
            message.getMsgInfo();
            Integer code = message.getMsgCode();
            if (code == 200 || code==500) {
                count++;
            }else {
                logger.warn("组织关系上传失败，"+message.getMsgInfo());
            }
        };
    }


    public void accountSync(){
        System.out.println("OrgSyncJob.accountSync");
    }

    public void mallSync(){
        System.out.println("OrgSyncJob.mallSync");
    }

}
