package com.viontech.keliu.job;


import com.viontech.keliu.Global;
import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.model.*;
import com.viontech.keliu.service.impl.DataCountServiceImpl;
import com.viontech.keliu.utils.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
public class DataCountSyncJob {

    @Autowired
    private DataCountServiceImpl dataCountServiceImpl;

    private final static Logger logger = LoggerFactory.getLogger(DataCountSyncJob.class);

    @Autowired
    User user;

    public void execute() throws IOException {
        //检测数据发送时间，长时间未发送成功则退出
        updateSendTime();

        login(user);
        logger.info("广场天开始请求");
        List<AccountDay> accountDayList= dataCountServiceImpl.account_day_query();
        logger.info("==="+accountDayList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("广场小时开始请求");
        List<AccountHour> accountHourList= dataCountServiceImpl.account_hour_query();
        logger.info("==="+accountHourList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("广场十分钟开始请求");
        List<AccountMinute> accountTenMinuteList= dataCountServiceImpl.account_minute_query();
        logger.info("==="+accountTenMinuteList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("广场级-出入口十分钟开始请求");
        List<AccountGateMinute> accountGateMinuteList= dataCountServiceImpl.account_gate_minute_query();
        logger.info("==="+accountGateMinuteList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("楼层天开始请求");
        List<FloorDay> floorDayList= dataCountServiceImpl.floor_day_query();
        logger.info("==="+floorDayList.size());


        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("楼层小时开始请求");
        List<FloorHour> floorHourList= dataCountServiceImpl.floor_hour_query();
        logger.info("==="+floorHourList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("店铺天开始请求");
        List<ShopDay> shopDayList= dataCountServiceImpl.shop_day_query();
        logger.info("==="+shopDayList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("店铺小时开始请求");
        List<ShopHour> zoneHourList= dataCountServiceImpl.shop_hour_query();
        logger.info("==="+zoneHourList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info("出入口天开始请求");
        List<GateDay> gateDayList= dataCountServiceImpl.gate_day_query();
        logger.info("==="+gateDayList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        logger.info("出入口小时开始请求");
        List<GateHour> gateHourList= dataCountServiceImpl.gate_hour_query();
        logger.info("==="+gateHourList.size());

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void login(User user) {
        try {
            List<User> list = new ArrayList<User>();
            list.add(user);
            HttpUtil.send(URLConstants.LOGIN_URL,list,(message) ->{
                if (message.getAtoken() != null && !message.getAtoken().trim().isEmpty() && !Global.atoken.equals(message.getAtoken())) {
                    Global.atoken = message.getAtoken();
                }
                logger.info("global.atoken值："+Global.atoken);
            },"");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("用户登录出错",e);
        }
    }

    public void updateSendTime(){
        //判断数据上传间隔（如果大于1小时无数据上传则退出程序）
        Date newDate=new Date();
        long diff= newDate.getTime()-dataCountServiceImpl.getLastSuccessTime().getTime();
        long nd=1000*24*60*60;
        long nh=1000*60*60;
        if(diff%nd/nh>1){
            logger.warn("1小时未正常上传数据，程序退出！");
//            System.exit(-1);
        }
    }

    public void accountSync(){
        System.out.println("OrgSyncJob.accountSync");
    }

    public void mallSync(){
        System.out.println("OrgSyncJob.mallSync");
    }

}
