package com.viontech.keliu.dao.impl;

import com.viontech.keliu.Global;
import com.viontech.keliu.dao.adapter.SendDataCountDao;
import com.viontech.keliu.model.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import javax.swing.text.html.parser.Entity;
import java.util.Date;
import java.util.List;

@Repository
public class SendDataCountDaoImpl implements SendDataCountDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    //广场天数据-
    private static final String ACCOUNT_DAY_SQL_QUERY = "select orgid as plaza_unid,countdate,innum,outnum,modifytime from tbl_count_info_org_day where orgid=? and countdate between ? and ? order by modifytime desc ";
    @Override
    public List<AccountDay> account_day_query(String PlazeId, Date Begin, Date End) {

        return jdbcTemplate.query(ACCOUNT_DAY_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<AccountDay>(AccountDay.class));
    }

    //广场小时数据-
    private static final String ACCOUNT_HOUR_SQL_QUERY = "select t.plaza_unid,t.countdate,to_timestamp(to_char(t.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') as counttime,sum(t.innum) as innum,sum(t.outnum) as outnum,max(modifytime) as modifytime from (\n" +
            "select orgid as plaza_unid,to_char(countdate,'yyyy-mm-dd') as countdate, fun_getfulltime(countdate,countindex-1) as counttime,innum,outnum,modifytime from tbl_count_info_org_minute where  orgid=? and countdate between ? and ? \n" +
            ") as t group by t.plaza_unid,t.countdate,to_timestamp(to_char(t.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') order by modifytime desc ";
    @Override
    public List<AccountHour> account_hour_query(String PlazeId,Date Begin,Date End) {

        return jdbcTemplate.query(ACCOUNT_HOUR_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<AccountHour>(AccountHour.class));
    }

    //广场十分钟数据-
    private static final String ACCOUNT_MINUTE_SQL_QUERY = "select orgid as plaza_unid,countdate, fun_getfulltime(countdate,countindex-1) as counttime,\n" +
            "innum,outnum,modifytime from tbl_count_info_org_minute where orgid=? and countdate between ? and ? order by modifytime desc";
    @Override
    public List<AccountMinute> account_minute_query(String PlazeId,Date Begin,Date End) {

        return jdbcTemplate.query(ACCOUNT_MINUTE_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<AccountMinute>(AccountMinute.class));
    }

    //广场级-出入口十分钟数据-
    private static final String ACCOUNT_GATE_MINUTE_SQL_QUERY="select c.orgid as plaza_unid,i.gateid as gate_unid,to_date(to_char(c.counttime,'yyyy-mm-dd'),'yyyy-mm-dd') as countdate,c.counttime,sum(innum) as innum,sum(outnum) as outnum \n" +
            ",max(modifytime) as modifytime from tbl_count_info_camera_minute as c,tbl_camera_info as i where c.cameraid=i.cameraid and  c.orgid=? and c.counttime between ? and ? \n" +
            "and i.gateid in (select r.gateid from tbl_zone_info as z,tbl_zonegate_relation as r where z.zoneid=r.zoneid and z.zoneattri=0) \n" +
            "group by plaza_unid,gate_unid,to_date(to_char(c.counttime,'yyyy-mm-dd'),'yyyy-mm-dd'), c.counttime order by modifytime desc ";
    @Override
    public List<AccountGateMinute> account_gate_minute_query(String PlazeId,Date Begin,Date End) {

        Date endTime = new Date(Begin.getTime() +Global.DAY- Global.SECOND);
        return jdbcTemplate.query(ACCOUNT_GATE_MINUTE_SQL_QUERY,new Object[]{PlazeId,Begin,endTime}, new BeanPropertyRowMapper<AccountGateMinute>(AccountGateMinute.class));
    }

    //楼层天数据-
    private static final String FLOOR_DAY_SQL_QUERY = "select d.orgid as plaza_unid,f.foorid as floor_unid,countdate,innum,outnum,modifytime from tbl_count_info_zone_day as d \n" +
            "inner join tbl_foor_info as f on d.zoneid=f.zoneid and  d.orgid=? and countdate between ? and ? order by modifytime desc ";
    @Override
    public List<FloorDay> floor_day_query(String PlazeId,Date Begin,Date End) {

        return jdbcTemplate.query(FLOOR_DAY_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<FloorDay>(FloorDay.class));
    }

    //楼层小时数据-
    private static final String FLOOR_HOUR_SQL_QUERY = "select t.plaza_unid,t.floor_unid,t.countdate,to_timestamp(to_char(t.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') as counttime,sum(t.innum) as innum,sum(t.outnum) as outnum,max(modifytime) as modifytime from (\n" +
            "select d.orgid as plaza_unid,f.foorid as floor_unid,countdate,innum,outnum,fun_getfulltime(countdate,countindex-1) as counttime,modifytime from tbl_count_info_zone_minute as d \n" +
            "inner join tbl_foor_info as f on d.zoneid=f.zoneid and  d.orgid=? and countdate between ? and ? \n" +
            ") as t group by t.plaza_unid,t.floor_unid,t.countdate,to_timestamp(to_char(t.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') order by modifytime desc ";
    @Override
    public List<FloorHour> floor_hour_query(String PlazeId,Date Begin,Date End) {

        return jdbcTemplate.query(FLOOR_HOUR_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<FloorHour>(FloorHour.class));
    }

    //店铺天数据-
    private static final String SHOP_DAY_SQL_QUERY = "select d.orgid as plaza_unid,f.foorid as floor_unid,d.zoneid as zone_unid,countdate,innum,outnum,modifytime from tbl_count_info_zone_day as d \n" +
            "inner join (select z1.zoneid,f1.foorid from tbl_zone_info z1 left join tbl_foor_info f1 on z1.zoneid=f1.zoneid ) as f on d.zoneid=f.zoneid and  d.orgid=? and countdate between ? and ? order by modifytime desc ";
    @Override
    public List<ShopDay> shop_day_query(String PlazeId,Date Begin,Date End) {

        return jdbcTemplate.query(SHOP_DAY_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<ShopDay>(ShopDay.class));
    }

    //店铺小时数据-
    private static final String SHOP_HOUR_SQL_QUERY = "select t.plaza_unid,t.zone_unid,t.floor_unid,t.countdate,to_timestamp(to_char(t.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') as counttime,sum(t.innum) as innum,sum(t.outnum) as outnum,max(modifytime) as modifytime from (\n" +
            "select d.orgid as plaza_unid,f.foorid as floor_unid,d.zoneid as zone_unid,countdate,innum,outnum,fun_getfulltime(countdate,countindex-1) as counttime,d.modifytime from tbl_count_info_zone_minute as d \n" +
            "inner join (select z1.zoneid,f1.foorid from tbl_zone_info z1 left join tbl_foor_info f1 on z1.zoneid=f1.zoneid ) as f \n" +
            "on d.zoneid=f.zoneid and  d.orgid=? and countdate between ? and ?)as t group by t.plaza_unid,t.floor_unid,t.zone_unid,t.countdate,to_timestamp(to_char(t.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') order by modifytime desc ";
    @Override
    public List<ShopHour> shop_hour_query(String PlazeId,Date Begin,Date End) {

        return jdbcTemplate.query(SHOP_HOUR_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<ShopHour>(ShopHour.class));
    }

    //出入口天数据-
    private static final String GATE_DAY_SQL_QUERY = "select c.orgid as plaza_unid,i.gateid as gate_unid,c.countdate,sum(innum) as innum,sum(outnum) as outnum,max(modifytime) as modifytime \n" +
                                                     "            from tbl_count_info_camera_day as c,tbl_camera_info as i where c.cameraid=i.cameraid \n" +
                                                     "            and  c.orgid=? and countdate between ? and ? \n" +
                                                     "            group by plaza_unid,gate_unid,countdate order by modifytime desc";
    @Override
    public List<GateDay> gate_day_query(String PlazeId,Date Begin,Date End) {

        return jdbcTemplate.query(GATE_DAY_SQL_QUERY,new Object[]{PlazeId,Begin,End}, new BeanPropertyRowMapper<GateDay>(GateDay.class));
    }

    //出入口小时数据-
    private static final String GATE_HOUR_SQL_QUERY = "select c.orgid as plaza_unid,i.gateid as gate_unid,to_date(to_char(c.counttime,'yyyy-mm-dd'),'yyyy-mm-dd') as countdate,\n" +
                                                      "            to_timestamp(to_char(c.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') as counttime,sum(innum) as innum,sum(outnum) as outnum,max(modifytime) as modifytime \n" +
                                                      "            from tbl_count_info_camera_minute as c,tbl_camera_info as i where c.cameraid=i.cameraid \n" +
                                                      "            and  c.orgid=? and c.counttime between ? and ? \n" +
                                                      "            group by plaza_unid,gate_unid,to_date(to_char(c.counttime,'yyyy-mm-dd'),'yyyy-mm-dd'), \n" +
                                                      "            to_timestamp(to_char(c.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') order by modifytime desc";
    @Override
    public List<GateHour> gate_hour_query(String PlazeId,Date Begin,Date End) {

        Date endTime = new Date(Begin.getTime() +Global.DAY- Global.SECOND);
        return jdbcTemplate.query(GATE_HOUR_SQL_QUERY,new Object[]{PlazeId,Begin,endTime}, new BeanPropertyRowMapper<GateHour>(GateHour.class));
    }

}

