package com.viontech.keliu.dao.impl;

import com.viontech.keliu.Global;
import com.viontech.keliu.dao.adapter.DataCountDao;
import com.viontech.keliu.model.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Repository
public class DataCountDaoImpl implements DataCountDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    //广场天数据-
    private static final String ACCOUNT_DAY_SQL_QUERY = "select orgid as plaza_unid,countdate,innum,outnum,modifytime from tbl_count_info_org_day where modifytime>=? order by modifytime desc ";
    @Override
    public List<AccountDay> account_day_query(Date modifytime) {

        return jdbcTemplate.query(ACCOUNT_DAY_SQL_QUERY,new Object[]{modifytime}, new BeanPropertyRowMapper<AccountDay>(AccountDay.class));
    }

    //广场小时数据-(时间过滤一周)
    private static final String ACCOUNT_HOUR_SQL_QUERY = "select * from z_view_org_hour where countdate >= ? and modifytime> ? order by modifytime desc ";
    @Override
    public List<AccountHour> account_hour_query(Date modifytime) {
        Date counttime = new Date(modifytime.getTime() - Global.DAY * 7L);

        return jdbcTemplate.query(ACCOUNT_HOUR_SQL_QUERY,new Object[]{counttime,modifytime}, new BeanPropertyRowMapper<AccountHour>(AccountHour.class));
    }

    //广场十分钟数据-
    private static final String ACCOUNT_MINUTE_SQL_QUERY = "select orgid as plaza_unid,countdate, fun_getfulltime(countdate,countindex-1) as counttime,\n" +
            "innum,outnum,modifytime from tbl_count_info_org_minute where modifytime >? order by modifytime desc";
    @Override
    public List<AccountMinute> account_minute_query(Date modifytime) {

        return jdbcTemplate.query(ACCOUNT_MINUTE_SQL_QUERY,new Object[]{modifytime}, new BeanPropertyRowMapper<AccountMinute>(AccountMinute.class));
    }

    //广场级-出入口十分钟数据-(时间过滤一周)
    private static final String ACCOUNT_GATE_MINUTE_SQL_QUERY="select * from z_view_gate_minute where \n" +
            "             gate_unid in (select r.gateid from tbl_zone_info as z,tbl_zonegate_relation as r where z.zoneid=r.zoneid and z.zoneattri=0) \n" +
            "            and counttime>=? and modifytime>? order by modifytime desc ";
    @Override
    public List<AccountGateMinute> account_gate_minute_query(Date modifytime) {
        Date counttime = new Date(modifytime.getTime() - Global.DAY * 7L);

        return jdbcTemplate.query(ACCOUNT_GATE_MINUTE_SQL_QUERY,new Object[]{counttime,modifytime}, new BeanPropertyRowMapper<AccountGateMinute>(AccountGateMinute.class));
    }

    //楼层天数据-
    private static final String FLOOR_DAY_SQL_QUERY = "select d.orgid as plaza_unid,f.foorid as floor_unid,countdate,innum,outnum,modifytime from tbl_count_info_zone_day as d \n" +
            "inner join tbl_foor_info as f on d.zoneid=f.zoneid and d.modifytime >? order by modifytime desc ";
    @Override
    public List<FloorDay> floor_day_query(Date modifytime) {

        return jdbcTemplate.query(FLOOR_DAY_SQL_QUERY,new Object[]{modifytime}, new BeanPropertyRowMapper<FloorDay>(FloorDay.class));
    }

    //楼层小时数据-(时间过滤一周)
    private static final String FLOOR_HOUR_SQL_QUERY = "select * from z_view_floor_hour where countdate >= ? and modifytime> ? order by modifytime desc ";
    @Override
    public List<FloorHour> floor_hour_query(Date modifytime) {
        Date counttime = new Date(modifytime.getTime() - Global.DAY * 7L);
        System.out.println(counttime);
        return jdbcTemplate.query(FLOOR_HOUR_SQL_QUERY,new Object[]{counttime,modifytime}, new BeanPropertyRowMapper<FloorHour>(FloorHour.class));
    }

    //店铺天数据-
    private static final String SHOP_DAY_SQL_QUERY = "select d.orgid as plaza_unid,f.foorid as floor_unid,d.zoneid as zone_unid,countdate countdate,innum,outnum,modifytime from tbl_count_info_zone_day as d \n" +
            "inner join (select z1.zoneid,f1.foorid from tbl_zone_info z1 left join tbl_foor_info f1 on z1.zoneid=f1.zoneid ) as f on d.zoneid=f.zoneid and d.modifytime >? order by modifytime desc ";
    @Override
    public List<ShopDay> shop_day_query(Date modifytime) {

        return jdbcTemplate.query(SHOP_DAY_SQL_QUERY,new Object[]{modifytime}, new BeanPropertyRowMapper<ShopDay>(ShopDay.class));
    }

    //店铺小时数据-(时间过滤一周)
    private static final String SHOP_HOUR_SQL_QUERY = "select * from z_view_zone_hour where countdate >= ? and modifytime> ? order by modifytime desc ";
    @Override
    public List<ShopHour> shop_hour_query(Date modifytime) {
        Date counttime = new Date(modifytime.getTime() -Global.DAY * 7L);

        return jdbcTemplate.query(SHOP_HOUR_SQL_QUERY,new Object[]{counttime,modifytime}, new BeanPropertyRowMapper<ShopHour>(ShopHour.class));
    }

    //出入口天数据-(时间过滤一周)
    private static final String GATE_DAY_SQL_QUERY = "select * from z_view_gate_day where countdate>=? and modifytime>? order by modifytime desc ";
    @Override
    public List<GateDay> gate_day_query(Date modifytime) {

        Date counttime = new Date(modifytime.getTime() -Global.DAY * 7L);
        return jdbcTemplate.query(GATE_DAY_SQL_QUERY,new Object[]{counttime,modifytime}, new BeanPropertyRowMapper<GateDay>(GateDay.class));
    }

    //出入口小时数据-(时间过滤一周)
    private static final String GATE_HOUR_SQL_QUERY = "select v.plaza_unid,v.gate_unid,v.countdate,to_timestamp(to_char(v.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') as counttime,sum(v.innum) as innum,sum(v.outnum) as outnum,max(modifytime) as modifytime \n" +
            " from z_view_gate_hour as v where counttime>=? and modifytime>? \n" +
            " group by v.plaza_unid,v.gate_unid,v.countdate,to_timestamp(to_char(v.counttime,'yyyy-mm-dd HH24:00:00'),'yyyy-mm-dd HH24:00:00') order by modifytime desc ";
    @Override
    public List<GateHour> gate_hour_query(Date modifytime) {
        Date counttime = new Date(modifytime.getTime() - Global.DAY * 7L);

        return jdbcTemplate.query(GATE_HOUR_SQL_QUERY,new Object[]{counttime,modifytime}, new BeanPropertyRowMapper<GateHour>(GateHour.class));
    }

}

