package com.viontech.keliu.controller;

import com.viontech.keliu.job.SendDataCountSyncJob;
import com.viontech.keliu.service.impl.AccountServiceImpl;
import com.viontech.keliu.vo.Form;
import com.viontech.keliu.vo.ResultVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@RestController
public class SendExecute implements WebMvcConfigurer {

    @Autowired
    private SendDataCountSyncJob sendData;
    @Autowired
    AccountServiceImpl accountService;

    @PostMapping("/send")
    public Object send(@RequestBody Form form){

        try {
            sendData.sendEexecute(form.getUnid(), form.getStartTime(), form.getEndTime());
        } catch (Exception e) {
            return new ResultVO(500, "出错了");
        }

        return new ResultVO(200, "成功");
    }

    @GetMapping("/getList")
    public Object get(){
        return accountService.p_query();
    }


    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                .allowedOrigins("*")
                .allowedMethods("GET", "POST")
                .allowCredentials(false).maxAge(3600);
    }
}
