package com.viontech.keliu;

import com.viontech.keliu.constant.URLConstants;
import com.viontech.keliu.http.VionHttpClient;
import com.viontech.keliu.http.VionRequest;
import com.viontech.keliu.http.VionResponse;
import com.viontech.keliu.job.DataCountSyncJob;
import com.viontech.keliu.job.OrgSyncJob;
import com.viontech.keliu.model.User;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.utils.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import javax.xml.bind.SchemaOutputResolver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;

import java.util.concurrent.CountDownLatch;

/**
 * Created by 苏曼 on 2018/9/21.
 */
@EnableAutoConfiguration
@SpringBootApplication
@ComponentScan(basePackages = { "com.viontech.*" })
@EnableScheduling
public class Application implements CommandLineRunner{
    Logger logger = LoggerFactory.getLogger(Application.class);

    @Autowired
    User user;
    public static void main(String[] args){
        try {
            SpringApplication.run(Application.class, args);
            new CountDownLatch(1).await();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    @Override
    public void run(String... args) throws Exception {
        System.out.println("程序已启动");
//        Thread.sleep(20*1000);
//        System.exit(-1);
    }

    @Autowired
    private OrgSyncJob orgSyncJob;

    @Scheduled(fixedDelay=1000*60*10,initialDelay=1000)
    public void startJob(){
        logger.info("组织机构同步任务开始");
        try {
            long begin = System.currentTimeMillis();
            orgSyncJob.execute();
            long end = System.currentTimeMillis();
            logger.info("组织机构同步任务结束,[组织关系][TIME][{}]",(end-begin)/1000L);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("组织关系定时处理Job发生异常,系统退出",e);
//            System.exit(-1);
        }
    }

    @Autowired
    private DataCountSyncJob dataCountSyncJob;

    //@Scheduled(cron = "0 0/10 * * * ?")
    @Scheduled(fixedDelay=1000*60*10,initialDelay=1000*20)
    public void startDataJob(){
        logger.info("数据同步任务开始");
        try {
            long begin = System.currentTimeMillis();
            dataCountSyncJob.execute();
            long end = System.currentTimeMillis();
            logger.info("数据同步任务结束，[数据上传][TIME]{}",((end-begin)/1000L));
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("数据上传定时处理Job发生异常,系统退出",e);
//            System.exit(-1);
        }
    }
}
