/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.CustomerDao;
import com.viontech.keliu.model.ZoneInfo;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tempuri.ArrayOfSyncContract;
import org.tempuri.ArrayOfSyncFlow;
import org.tempuri.Sync;
import org.tempuri.SyncContract;
import org.tempuri.SyncContractResult;
import org.tempuri.SyncFlow;
import org.tempuri.SyncResult;

@Service
public class CustomerService {
    @Autowired
    private CustomerDao customerDao;
    Logger log = LoggerFactory.getLogger(CustomerService.class);
    Date orgModifyTime = null;
    Date zoneModifyTime = null;
    Date now = null;

    public CustomerService() {
        LocalDate localDate = LocalDate.now();
        this.now = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public void org_gate_day_query(String AppCode, String AppKey, String PropertyId) {
        System.out.println("\u5f00\u59cb\u8c03\u7528");
        if (this.orgModifyTime == null) {
            this.orgModifyTime = this.now;
        }
        List syncOrgFlowList = this.customerDao.org_gate_day_query(this.orgModifyTime);
        System.out.println("\u83b7\u53d6\u6570\u636e");
        if (syncOrgFlowList.size() > 0) {
            System.out.println("\u8c03\u7528\u63a5\u53e3");
            ArrayOfSyncFlow list = new ArrayOfSyncFlow();
            list.getSyncFlow().addAll(syncOrgFlowList);
            Sync sync = new Sync();
            try {
                SyncResult result = sync.getSyncSoap().setCustomerFlow(AppCode, AppKey, PropertyId, list);
                if (result.isSuccess()) {
                    this.orgModifyTime = ((SyncFlow)syncOrgFlowList.get(0)).getModifytime();
                    this.log.info(result.getCode() + "/" + result.getMessage());
                } else {
                    this.log.error(result.getCode() + "/" + result.getMessage());
                }
            }
            catch (WebServiceException e) {
                this.log.error("\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
                e.printStackTrace();
            }
        }
        System.out.println("\u5b8c\u6210");
    }

    public void zone_day_query(String AppCode, String AppKey, String PropertyId) {
        System.out.println("\u5f00\u59cb\u8c03\u7528");
        if (this.zoneModifyTime == null) {
            this.zoneModifyTime = this.now;
        }
        List syncZoneFlowList = this.customerDao.zone_day_query(this.zoneModifyTime);
        System.out.println("\u83b7\u53d6\u6570\u636e");
        if (syncZoneFlowList.size() > 0) {
            System.out.println("\u8c03\u7528\u63a5\u53e3");
            ArrayOfSyncFlow list = new ArrayOfSyncFlow();
            list.getSyncFlow().addAll(syncZoneFlowList);
            Sync sync = new Sync();
            try {
                SyncResult result = sync.getSyncSoap().setCustomerFlow(AppCode, AppKey, PropertyId, list);
                if (result.isSuccess()) {
                    this.zoneModifyTime = ((SyncFlow)syncZoneFlowList.get(0)).getModifytime();
                    this.log.info(result.getCode() + "/" + result.getMessage());
                } else {
                    this.log.error(result.getCode() + "/" + result.getMessage());
                }
            }
            catch (WebServiceException e) {
                this.log.error("\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
                e.printStackTrace();
            }
        }
        System.out.println("\u5b8c\u6210");
    }

    public Object get_contract_query(String AppCode, String AppKey, String PropertyId) {
        List contractList = this.customerDao.contract_info_query();
        if (contractList.size() > 0) {
            return contractList;
        }
        Sync sync = new Sync();
        SyncContractResult contractResult = sync.getSyncSoap().getContractInfo(AppCode, AppKey, PropertyId);
        ArrayOfSyncContract list = contractResult.getContractList();
        return list.getSyncContract();
    }

    public List<ZoneInfo> get_zone_query() {
        List zonelist = this.customerDao.zone_info_query();
        return zonelist;
    }

    public int zone_contract_update(String contractid, Long zoneid) {
        int result = this.customerDao.zone_contract_update(contractid, zoneid);
        return result;
    }

    public int contract_info_add(String AppCode, String AppKey, String PropertyId) {
        int resultIndex = 0;
        Sync sync = new Sync();
        SyncContractResult contractResult = sync.getSyncSoap().getContractInfo(AppCode, AppKey, PropertyId);
        ArrayOfSyncContract list = contractResult.getContractList();
        if (list.getSyncContract().size() > 0) {
            this.customerDao.contract_info_delete();
            for (SyncContract temp : list.getSyncContract()) {
                resultIndex += this.customerDao.contract_info_add(temp);
            }
        }
        return resultIndex;
    }

    public void his_countdata_day(String AppCode, String AppKey, String PropertyId, Date beginDate, Date endDate) {
        System.out.println("\u5f00\u59cb\u8c03\u7528");
        List syncOrgFlowList = this.customerDao.org_his_gate_day_query(beginDate, endDate);
        List syncZoneFlowList = this.customerDao.zone_his_day_query(beginDate, endDate);
        System.out.println("\u83b7\u53d6\u5386\u53f2\u6570\u636e");
        if (syncOrgFlowList.size() > 0) {
            System.out.println("\u8c03\u7528\u5386\u53f2\u6570\u636e\u63a5\u53e3");
            ArrayOfSyncFlow list = new ArrayOfSyncFlow();
            list.getSyncFlow().addAll(syncOrgFlowList);
            list.getSyncFlow().addAll(syncZoneFlowList);
            Sync sync = new Sync();
            try {
                SyncResult result = sync.getSyncSoap().setCustomerFlow(AppCode, AppKey, PropertyId, list);
                if (result.isSuccess()) {
                    this.log.info(result.getCode() + "/" + result.getMessage());
                } else {
                    this.log.error(result.getCode() + "/" + result.getMessage());
                }
            }
            catch (WebServiceException e) {
                this.log.error("\u5386\u53f2\u6570\u636e\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
                e.printStackTrace();
            }
        }
        System.out.println("\u5386\u53f2\u6570\u636e\u53d1\u9001\u5b8c\u6210");
    }
}

