/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.ContractInfo;
import com.viontech.keliu.model.ZoneInfo;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.tempuri.SyncContract;
import org.tempuri.SyncFlow;

@Repository
public class CustomerDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String ORG_GATE_DAY_SQL_QUERY = "select g.unid as PositionId,g.name as PositionName,'2' as PositioTypeId,'\u4e3b\u51fa\u5165\u53e3' as PositioType,\n            d.countdate as date,sum(innum) as FlowCount,d.modify_time as modifytime from d_gate_day_count_data as d,b_gate as g where \n            d.gate_id=g.id and g.is_mall_gate !=0 and d.modify_time>=?  \n            group by g.unid,g.name,d.countdate,modifytime order by modifytime desc ";
    private static final String ORG_HIS_GATE_DAY_SQL_QUERY = "select g.unid as PositionId,g.name as PositionName,'2' as PositioTypeId,'\u4e3b\u51fa\u5165\u53e3' as PositioType,\n            d.countdate as date,sum(innum) as FlowCount,d.modify_time as modifytime from d_gate_day_count_data as d,b_gate as g where \n            d.gate_id=g.id and g.is_mall_gate !=0 and d.countdate between ? and ? \n            group by g.unid,g.name,d.countdate,modifytime order by modifytime desc ";
    private static final String ZONE_DAY_SQL_QUERY = "select z.external_id as PositionId,z.name as PositionName,'1' as PositioTypeId,'\u5e97\u94fa\u7c7b' as PositioType,d.countdate as FlowDate,d.innum as FlowCount,d.modify_time as modifytime from \nb_zone as z,d_zone_day_count_data as d where z.id=d.zone_id and z.external_id !='' and d.countdate=? order by modifytime desc ";
    private static final String ZONE_HIS_DAY_SQL_QUERY = "select z.external_id as PositionId,z.name as PositionName,'1' as PositioTypeId,'\u5e97\u94fa\u7c7b' as PositioType,d.countdate as FlowDate,d.innum as FlowCount,d.modify_time as modifytime from \nb_zone as z,d_zone_day_count_data as d where z.id=d.zone_id and z.external_id !='' and d.countdate between ? and ? order by modifytime desc ";
    private static final String ZONE_INFO_SQL_QUERY = "select b.id as zoneid,b.name as zonename,b.external_id as code,c.contractstatus as status,c.rentalid as cid from contract_info as c right join b_zone as b on c.contractno=b.external_id and b.type=1";
    private static final String ZONE_CONTRACT_SQL_UPDATE = "update b_zone set external_id=? where id=? ";
    private static final String CONTRACT_INFO_SQL_QUERY = "select * from contract_info";
    private static final String CONTRACT_INFO_SQL_DELETE = "delete from contract_info";
    private static final String CONTRACT_INFO_SQL_ADD = "insert into contract_info values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public List<SyncFlow> org_gate_day_query(Date counttime) {
        return this.jdbcTemplate.query(ORG_GATE_DAY_SQL_QUERY, new Object[]{counttime}, (RowMapper)new BeanPropertyRowMapper(SyncFlow.class));
    }

    public List<SyncFlow> org_his_gate_day_query(Date beginDate, Date endDate) {
        return this.jdbcTemplate.query(ORG_HIS_GATE_DAY_SQL_QUERY, new Object[]{beginDate, endDate}, (RowMapper)new BeanPropertyRowMapper(SyncFlow.class));
    }

    public List<SyncFlow> zone_day_query(Date counttime) {
        return this.jdbcTemplate.query(ZONE_DAY_SQL_QUERY, new Object[]{counttime}, (RowMapper)new BeanPropertyRowMapper(SyncFlow.class));
    }

    public List<SyncFlow> zone_his_day_query(Date beginDate, Date endDate) {
        return this.jdbcTemplate.query(ZONE_HIS_DAY_SQL_QUERY, new Object[]{beginDate, endDate}, (RowMapper)new BeanPropertyRowMapper(SyncFlow.class));
    }

    public List<ZoneInfo> zone_info_query() {
        return this.jdbcTemplate.query(ZONE_INFO_SQL_QUERY, (RowMapper)new BeanPropertyRowMapper(ZoneInfo.class));
    }

    public int zone_contract_update(String ContractId, Long ZoneId2) {
        return this.jdbcTemplate.update(ZONE_CONTRACT_SQL_UPDATE, new Object[]{ContractId, ZoneId2});
    }

    public List<ContractInfo> contract_info_query() {
        return this.jdbcTemplate.query(CONTRACT_INFO_SQL_QUERY, (RowMapper)new BeanPropertyRowMapper(ContractInfo.class));
    }

    public void contract_info_delete() {
        this.jdbcTemplate.execute(CONTRACT_INFO_SQL_DELETE);
    }

    public int contract_info_add(SyncContract contract) {
        return this.jdbcTemplate.update(CONTRACT_INFO_SQL_ADD, new Object[]{contract.getRentalId(), contract.getContractNo(), contract.getPropertyId(), contract.getPropertyName(), contract.getDebtorId(), contract.getDebtorName(), contract.getFloorNo(), contract.getUnitDesc(), contract.getRentArea(), contract.getFstFormatId(), contract.getFstFormatName(), contract.getSecFormatId(), contract.getSecFormatName(), contract.getThdFormatId(), contract.getThdFormatName(), contract.getBrandId(), contract.getBrandName(), contract.getBeginDate(), contract.getLastDate(), contract.getContractType(), contract.getContractStatus()});
    }
}

