/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.job;

import com.viontech.keliu.model.Plaza;
import com.viontech.keliu.model.ZoneInfo;
import com.viontech.keliu.service.CustomerService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
public class CustomerJob {
    @Autowired
    private CustomerService customerService;
    @Value(value="${AppCode}")
    private String AppCode;
    @Value(value="${AppKey}")
    private String AppKey;
    @Value(value="${PropertyId}")
    private String PropertyId;

    public String getAppCode() {
        return this.AppCode;
    }

    public void setAppCode(String appCode) {
        this.AppCode = appCode;
    }

    public String getAppKey() {
        return this.AppKey;
    }

    public void setAppKey(String appKey) {
        this.AppKey = appKey;
    }

    public String getPropertyId() {
        return this.PropertyId;
    }

    public void setPropertyId(String propertyId) {
        this.PropertyId = propertyId;
    }

    public void getSyncResult() {
        this.customerService.org_gate_day_query(this.AppCode, this.AppKey, this.PropertyId);
        this.customerService.zone_day_query(this.AppCode, this.AppKey, this.PropertyId);
    }

    public void getSyncHisResult(Date beginDate, Date endDate) {
        this.customerService.his_countdata_day(this.AppCode, this.AppKey, this.PropertyId, beginDate, endDate);
    }

    public Object getSyncContractResult() {
        return this.customerService.get_contract_query(this.AppCode, this.AppKey, this.PropertyId);
    }

    public List<ZoneInfo> getSyncZoneListResult() {
        return this.customerService.get_zone_query();
    }

    public int updateSyncZoneContractResult(String contractid, Long zoneid) {
        return this.customerService.zone_contract_update(contractid, zoneid);
    }

    public int addSyncContractResult() {
        return this.customerService.contract_info_add(this.AppCode, this.AppKey, this.PropertyId);
    }

    public List<Plaza> getPlazaList() {
        ArrayList<Plaza> plazaList = new ArrayList<Plaza>();
        Plaza plaza = new Plaza();
        plaza.setPlaza_name("\u53e5\u5bb9\u543e\u60a6\u5e7f\u573a");
        plaza.setPlaza_unid(this.PropertyId);
        plaza.setStatus(Integer.valueOf(0));
        plaza.setPlaza_city("1");
        plaza.setPlaza_lat("40.009586");
        plaza.setPlaza_lng("116.42661");
        plazaList.add(plaza);
        return plazaList;
    }
}

