/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.controller;

import com.viontech.keliu.job.CustomerJob;
import com.viontech.keliu.vo.ConfigEntity;
import com.viontech.keliu.vo.Form;
import com.viontech.keliu.vo.ResultVO;
import com.viontech.keliu.vo.UpdateVo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@RefreshScope
@RestController
public class SendExecute
implements WebMvcConfigurer {
    @Autowired
    private CustomerJob customerJob;
    @Value(value="${AppCode}")
    private String appCode;
    @Value(value="${AppKey}")
    private String appKey;
    @Value(value="${PropertyId}")
    private Integer propertyId;

    @GetMapping(value={"/config"})
    public ConfigEntity getConfig() {
        ConfigEntity configEntity = new ConfigEntity();
        configEntity.setAppCode(this.appCode);
        configEntity.setPropertyId(this.propertyId);
        configEntity.setAppKey(this.appKey);
        return configEntity;
    }

    @PostMapping(value={"/updateConfig"})
    public Object updateConfig(@RequestBody ConfigEntity entity) throws IOException {
        File file = new File("application-option.properties");
        if (!file.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("AppCode=" + entity.getAppCode() + "\n");
        writer.write("AppKey=" + entity.getAppKey() + "\n");
        writer.write("PropertyId=" + entity.getPropertyId() + "\n");
        writer.close();
        return true;
    }

    @PostMapping(value={"/send"})
    public Object send(@RequestBody Form form) {
        try {
            this.customerJob.getSyncHisResult(form.getStartTime(), form.getEndTime());
        }
        catch (Exception e) {
            return new ResultVO(Integer.valueOf(500), "\u51fa\u9519\u4e86");
        }
        return new ResultVO(Integer.valueOf(200), "\u6210\u529f");
    }

    @GetMapping(value={"/getZoneList"})
    public Object getzonelist() {
        return this.customerJob.getSyncZoneListResult();
    }

    @GetMapping(value={"/getContractList"})
    public Object getcontractlist() {
        return this.customerJob.getSyncContractResult();
    }

    @PostMapping(value={"/updateZoneContract"})
    public Object updatezonecontract(@RequestBody UpdateVo updateVo) {
        return this.customerJob.updateSyncZoneContractResult(updateVo.getContractId(), updateVo.getZoneId());
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST"}).allowCredentials(false).maxAge(3600L);
    }
}

