/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu;

import com.viontech.keliu.job.CustomerJob;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@ComponentScan(basePackages={"com.viontech.*", "org.tempuri"})
@EnableAutoConfiguration
@SpringBootApplication
@EnableScheduling
public class Application
implements CommandLineRunner {
    Logger log = LoggerFactory.getLogger(Application.class);
    @Autowired
    private CustomerJob customerJob;

    public static void main(String[] args) {
        File file = new File("application-option.properties");
        if (!file.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            SpringApplication.run(Application.class, (String[])args);
            new CountDownLatch(1).await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Scheduled(fixedDelay=600000L, initialDelay=1000L)
    public void startJob() {
        this.log.info("\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb");
        try {
            long begin = System.currentTimeMillis();
            this.customerJob.getSyncResult();
            long end = System.currentTimeMillis();
            this.log.info("\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f\uff0c[\u6570\u636e\u4e0a\u4f20][TIME]{}", (Object)((end - begin) / 1000L));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u6570\u636e\u4e0a\u4f20\u5b9a\u65f6\u5904\u7406Job\u53d1\u751f\u5f02\u5e38,\u7cfb\u7edf\u9000\u51fa", (Throwable)e);
        }
    }

    @Scheduled(fixedDelay=86400000L, initialDelay=5000L)
    public void startContractJob() {
        this.log.info("\u5408\u540c\u540c\u6b65\u4efb\u52a1\u5f00\u59cb");
        try {
            long begin = System.currentTimeMillis();
            this.customerJob.addSyncContractResult();
            long end = System.currentTimeMillis();
            this.log.info("\u5408\u540c\u540c\u6b65\u4efb\u52a1\u7ed3\u675f\uff0c[\u6570\u636e\u4e0a\u4f20][TIME]{}", (Object)((end - begin) / 1000L));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("\u5408\u540c\u4e0a\u4f20\u5b9a\u65f6\u5904\u7406Job\u53d1\u751f\u5f02\u5e38,\u7cfb\u7edf\u9000\u51fa", (Throwable)e);
        }
    }

    public void run(String ... args) throws Exception {
    }
}

