package com.viontech.keliu.service;

import com.viontech.keliu.model.FaceRecognition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 * @Author: 王洪波
 * @Date: 2019/6/10.
 * @Description:新老顾客unid匹配service，两处引用
 */
@Service
public class HistoryArriveCountService {

    private Logger logger = LoggerFactory.getLogger(HistoryArriveCountService.class);

    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private final String SQL_QUERY_HISTORYARRIVALCOUNT = "select person_unid,history_arrival_count from d_face_recognition where countdate=? and mall_id=? and status = 1 ORDER BY counttime DESC";

    private static final Object LOCK = new Object();
    private ThreadLocal<SimpleDateFormat> sdf = ThreadLocal.withInitial(()->new SimpleDateFormat("yyyyMMdd"));

    public boolean putHistoryArriveCount(FaceRecognition faceRecognition) {
        String dateStr = sdf.get().format(faceRecognition.getCountdate());
        String key = "historyArrivalInfo:" + "day:" + "mall:" + dateStr + ":" + faceRecognition.getMallId();
        BoundHashOperations boundHashOperations = redisTemplate.boundHashOps(key);
        // 加载数据库历史到店次数到Redis
        loadHistoryArriveCount2Redis(faceRecognition,key);
        // 如果客户有历史到店次数 那么覆盖当前的到店次数，否则使用redis中的
        Short result =  (Short)boundHashOperations.get(faceRecognition.getPersonUnid());
        if(result == null){
            boundHashOperations.put(faceRecognition.getPersonUnid(),faceRecognition.getHistoryArrivalCount());
            return true;
        }else{
            faceRecognition.setHistoryArrivalCount(result);
            return false;
        }

    }

    public boolean hasHistoryArriveCount(FaceRecognition faceRecognition){
        String dateStr = sdf.get().format(faceRecognition.getCountdate());
        String key = "historyArrivalInfo:" + "day:" + "mall:" + dateStr + ":" + faceRecognition.getMallId();
        BoundHashOperations boundHashOperations = redisTemplate.boundHashOps(key);
        // 加载数据库历史到店次数到Redis
        loadHistoryArriveCount2Redis(faceRecognition,key);
        // 如果客户有历史到店次数 那么覆盖当前的到店次数，否则使用redis中的
        Short result =  (Short)boundHashOperations.get(faceRecognition.getPersonUnid());
        if(result == null){
            return true;
        }else{
            faceRecognition.setHistoryArrivalCount(result);
            return false;
        }
    }
    private void loadHistoryArriveCount2Redis(FaceRecognition faceRecognition, String key){
        // 键值是否存在 使用续期的方式，防止haskey为true 取值的时候被销毁
        if(!redisTemplate.expire(key,2,TimeUnit.DAYS)){
            synchronized (LOCK) {
                if (!redisTemplate.hasKey(key)) {
                    Map<String,Short> result = new HashMap();
                    jdbcTemplate.query(SQL_QUERY_HISTORYARRIVALCOUNT, new Object[]{faceRecognition.getCountdate(),faceRecognition.getMallId()},  rs -> {
                        result.put(rs.getString("person_unid"),rs.getShort("history_arrival_count"));
                    });
                    redisTemplate.executePipelined(new SessionCallback<Object>() {
                        @Override
                        public Object execute(RedisOperations operations) throws DataAccessException {
                            BoundHashOperations boundHashOperations = operations.boundHashOps(key);
                            result.forEach((itemKey,itemValue) ->{
                                boundHashOperations.put(itemKey,itemValue);
                            });
                            return null;
                        }
                    });
                }
            }
        }
    }
}
