package com.viontech.keliu.runner;

import com.viontech.keliu.model.License;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.UUID;

/**
 * Created by 苏曼 on 2018/9/26.
 */
@Component
@Order(11)
public class HistoryArriveJobStartRunner implements CommandLineRunner {

    /**
     * 任务存储库
     */
    @Autowired
    JobRepository jobRepository;

    /**
     * 新老顾客处理job
     */
    @Resource
    Job historyArriveJob;

    @Autowired
    TaskExecutor taskExecutor;

    @Override
    public void run(String... args) throws Exception {
        License.cpuIdCheck = true;
        License.diskIdCheck=true;
        License.dateCheck=true;
        License.mainborrdCheck=true;
        SimpleJobLauncher sjl = new SimpleJobLauncher();
        sjl.setJobRepository(jobRepository);
        sjl.setTaskExecutor(taskExecutor);
        sjl.afterPropertiesSet();
        for (int i = 0; i < 10; i++) {
            JobParameters jobParameters = new JobParametersBuilder().addString("uuid",UUID.randomUUID().toString()).toJobParameters();
            sjl.run(historyArriveJob,jobParameters);
        }
    }
}
