package com.viontech.keliu.runner;

import com.viontech.keliu.dao.MallDao;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.MallDayHistoryArriveCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

/**
 * .
 *
 * @author 谢明辉
 */
@Component
public class HistoryArriveCountJob {

    private Logger logger = LoggerFactory.getLogger(HistoryArriveCountJob.class);

    @Resource
    private MallDao mallDao;
    @Resource
    private JdbcTemplate template;
    private final static BeanPropertyRowMapper<FaceRecognition> FACE_BEAN_MAPPER = new BeanPropertyRowMapper<>(FaceRecognition.class);

    @Scheduled(cron = "0 0 3 * * ?")

    public void run() {
        try {
            Date yesterday = Date.from(LocalDate.now().plusDays(-1).atStartOfDay(ZoneId.systemDefault()).toInstant());
            List<Mall> malls = mallDao.selectAll();

            for (Mall mall : malls) {
                try {
                    boolean b = reCalHistoryArriveCount(mall.getId(), yesterday);
                    if (b) {
                        logger.info("{}历史到店次数重跑成功", mall.getName());
                    } else {
                        logger.error(mall.getName() + "历史到店次数重跑失败，跳过");
                    }
                } catch (Exception e) {
                    logger.error(mall.getName() + "历史到店次数重跑失败，跳过", e);
                }
            }
        } catch (Exception e) {
            logger.error("重跑历史到店次数失败", e);
        }
    }


    public boolean reCalHistoryArriveCount(Long mallId, Date date) {
        List<FaceRecognition> faceData = getHistoryArriveCountByMallIdAndDate(mallId, date);
        if (faceData.size() == 0) {
            return true;
        }
        MallDayHistoryArriveCount result = new MallDayHistoryArriveCount();
        result.setCountdate(date);
        result.setMallId(mallId);
        for (FaceRecognition data : faceData) {
            result.setAccountId(data.getAccountId());
            result.add(data.getHistoryArrivalCount());
        }
        return updateOrInsertHistoryArriveCount(result);
    }


    private List<FaceRecognition> getHistoryArriveCountByMallIdAndDate(Long mallId, Date date) {
        String sql = "select DISTINCT on (person_unid) person_unid,mall_id,history_arrival_count,countdate,counttime from d_face_recognition where countdate = ? and mall_id=? and gate_id in (select id from b_gate where b_gate.mall_id=? and is_mall_gate=1) and direction=1 and person_type = 0 order by person_unid,counttime";
        return template.query(sql, FACE_BEAN_MAPPER, date, mallId,mallId);
    }

    private boolean updateOrInsertHistoryArriveCount(MallDayHistoryArriveCount data) {
        try {
            String sqlCount = "select count(*) from d_mall_day_history_arrive_count where countdate=? and mall_id=?";
            String sqlUpdate = "update d_mall_day_history_arrive_count set once=?,twice=?,third=?,fourth=?,fifth=?,more=? where countdate=? and mall_id=?";
            String sqlInsert = "insert into d_mall_day_history_arrive_count(mall_id,account_id,countdate,once,twice,third,fourth,fifth,more) values (?,?,?,?,?,?,?,?,?)";
            Integer count = template.queryForObject(sqlCount, Integer.class, data.getCountdate(), data.getMallId());
            if (count != null && count > 0) {
                template.update(sqlUpdate, data.getOnce(), data.getTwice(), data.getThird(), data.getFourth(), data.getFifth(), data.getMore(), data.getCountdate(), data.getMallId());
            } else {
                template.update(sqlInsert, data.getMallId(), data.getAccountId(), data.getCountdate(), data.getOnce(), data.getTwice(), data.getThird(), data.getFourth(), data.getFifth(), data.getMore());
            }
        } catch (Exception e) {
            logger.error("", e);
            return false;
        }
        return true;
    }

}
