package com.viontech.keliu.jobhandler;

import com.viontech.keliu.constants.RedisKeyConstants;
import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * @Author: 王洪波
 * @Date: 2019/6/3.
 * @Description:封装新老顾客处理列表Job
 */
@Component("faceRecognitionDB2RedisJob")
public class FaceRecognitionDB2RedisJob {

    private Logger logger = LoggerFactory.getLogger(FaceRecognitionDB2RedisJob.class);

    @Autowired
    private FaceRecognitionDao faceRecognitionDao;


    @Scheduled(cron = "0 0/1 * * * ?")
    public void timing() {
        logger.info("FaceRecognitionDB2RedisJob-任务开始");
        process();
    }

    private void process(){
        //注意点：如果redis读取不到key,只处理今天的数据，如果可以找到id根据id limit 1000 查询，直到查没结束定时。
        while(true) {
            long listSize = RedisUtil.getListSize(RedisKeyConstants.NEW_REGULAR_CUSTOM_PROCESS_LIST);
            if(listSize > 10000){
                logger.info("新老顾客待处理队列数为:{},跳过插入队列操作。",listSize);
                break;
            }
            Long processEntry = (Long) RedisUtil.get(RedisKeyConstants.NEW_REGULAR_CUSTOM_PROCESS_ENTRY);
            logger.info("开始读取人脸抓拍数据到redis,key为:newRegularCustomReader4Redis,当前处理id为:{}", processEntry);

            List<FaceRecognition> faceRecognitions;
            if (processEntry == null || processEntry <= 0) {
                faceRecognitions = faceRecognitionDao.selectListByCountDate(new Date());
            } else {
                faceRecognitions = faceRecognitionDao.selectlistById(processEntry);
            }
            if (faceRecognitions == null || faceRecognitions.size() <= 0) {
                logger.info("读取不到人脸抓拍数据，跳过本次处理");
                break;
            }

            Long maxId = -1L;
            for (FaceRecognition faceRecognition : faceRecognitions) {
                Long id = faceRecognition.getId();
                if (id > maxId) {
                    maxId = id;
                }
                RedisUtil.addList(RedisKeyConstants.NEW_REGULAR_CUSTOM_PROCESS_LIST, faceRecognition);
            }
            if (maxId > -1L) {
                RedisUtil.set(RedisKeyConstants.NEW_REGULAR_CUSTOM_PROCESS_ENTRY, maxId);
            }

        }
    }
}
