package com.viontech.keliu.controller;

import com.viontech.keliu.runner.HistoryArriveCountJob;
import com.viontech.keliu.util.DateUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * .
 *
 * @author 谢明辉
 */
@RestController
@RequestMapping("/regular/tool")
public class ToolController {

    @Resource
    private HistoryArriveCountJob historyArriveCountJob;


    @GetMapping("/historyArriveCount")
    public Object historyArriveCountReCal(@RequestParam("mallIds") Long[] mallIds, @RequestParam("startDate") Date startDate, @RequestParam("endDate") Date endDate) {
        List<Date> days = DateUtil.getDaysBetweenStartDateAndEndDate(startDate, endDate);
        Collections.reverse(days);
        for (Date day : days) {
            for (Long mallId : mallIds) {
                historyArriveCountJob.reCalHistoryArriveCount(mallId, day);
            }
        }
        return "重跑历史到店次数成功";
    }

}
